/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.Putting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.inscription.arc.FlexibleArc;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;
import de.renew.unify.List;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

class FlexibleOutArcExecutable
implements LateExecutable {
    private final SimulatablePlaceInstance _placeInstance;
    private final Variable _tokenVar;
    private final FlexibleArc _arc;

    FlexibleOutArcExecutable(SimulatablePlaceInstance placeInstance, Variable tokenVar, FlexibleArc arc) {
        this._placeInstance = placeInstance;
        this._tokenVar = tokenVar;
        this._arc = arc;
    }

    @Override
    public int phase() {
        return 3;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    private void putSingleToken(StepIdentifier stepIdentifier, Object token) {
        if (this._arc.getForwardFunction() != null) {
            try {
                token = this._arc.getForwardFunction().function(token);
            }
            catch (Impossible impossible) {
                // empty catch block
            }
        }
        if (this._arc.getTrace()) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Putting(token, this._placeInstance), (PlaceInstance)this._placeInstance);
        }
        this._placeInstance.insertToken(token, SearchQueue.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(StepIdentifier stepIdentifier) {
        block17: {
            Object tokens = this._tokenVar.getValue();
            this._placeInstance._lock.lock();
            try {
                if (tokens == null) {
                    break block17;
                }
                if (tokens instanceof Iterator) {
                    Iterator i = (Iterator)tokens;
                    while (i.hasNext()) {
                        this.putSingleToken(stepIdentifier, i.next());
                    }
                    break block17;
                }
                if (tokens instanceof Enumeration) {
                    Enumeration enumeration = (Enumeration)tokens;
                    while (enumeration.hasMoreElements()) {
                        this.putSingleToken(stepIdentifier, enumeration.nextElement());
                    }
                    break block17;
                }
                if (tokens.getClass().isArray()) {
                    Class<?> elementType = tokens.getClass().getComponentType();
                    for (int i = 0; i < Array.getLength(tokens); ++i) {
                        Object token = Array.get(tokens, i);
                        if (elementType.isPrimitive()) {
                            token = new Value(token);
                        }
                        this.putSingleToken(stepIdentifier, token);
                    }
                    break block17;
                }
                if (tokens instanceof List) {
                    List current = (List)tokens;
                    while (!current.isNull()) {
                        this.putSingleToken(stepIdentifier, current.head());
                        if (!(current.tail() instanceof List)) {
                            break block17;
                        }
                        current = (List)current.tail();
                    }
                    break block17;
                }
                if (tokens instanceof Collection) {
                    Collection coll = (Collection)tokens;
                    for (Object o : coll) {
                        this.putSingleToken(stepIdentifier, o);
                    }
                } else {
                    this.putSingleToken(stepIdentifier, tokens);
                }
            }
            finally {
                this._placeInstance._lock.unlock();
            }
        }
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {
    }
}

