/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.Clearing;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.inscription.arc.ClearArc;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Vector;

class ClearArcExecutable
implements EarlyExecutable {
    private final SimulatablePlaceInstance _placeInstance;
    private final Variable _variable;
    private final ClearArc _arc;
    private Vector<Object> _removedTokens;
    private Vector<Double> _removedTimeStamps;

    ClearArcExecutable(SimulatablePlaceInstance pInstance, Variable variable, ClearArc arc) {
        this._placeInstance = pInstance;
        this._variable = variable;
        this._arc = arc;
    }

    public long lockPriority() {
        return this._placeInstance.getLockOrder();
    }

    @Override
    public int phase() {
        return -1;
    }

    public void lock() {
        this._placeInstance._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this._removedTokens = new Vector(8, 0);
        this._removedTimeStamps = new Vector(8, 0);
        this._placeInstance.extractAllTokens(this._removedTokens, this._removedTimeStamps);
        Object result = Array.newInstance(this._arc.getElementType(), this._removedTokens.size());
        for (int i = 0; i < this._removedTokens.size(); ++i) {
            Object value = this._removedTokens.elementAt(i);
            if (this._arc.getElementType().isPrimitive()) {
                value = Value.unvalueAndCast((Object)value, this._arc.getElementType());
            }
            Array.set(result, i, value);
        }
        Unify.unify(this._variable, result, null);
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this._arc.getTrace()) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Clearing(this._placeInstance), (PlaceInstance)this._placeInstance);
        }
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this._removedTokens.size(); ++i) {
            Object token = this._removedTokens.elementAt(i);
            double time = this._removedTimeStamps.elementAt(i);
            this._placeInstance.internallyInsertToken(token, time, false);
        }
        this._removedTokens = null;
    }

    public void unlock() {
        this._placeInstance._lock.unlock();
    }
}

