/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searcher.DeltaSet;
import de.renew.engine.searcher.DeltaSetFactory;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReservation;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class TokenReserver
implements DeltaSet {
    private static final Factory FACTORY = new Factory();
    private Hashtable<SimulatablePlaceInstance, TokenReservation> _reservations = new Hashtable();

    public static TokenReserver getInstance(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return (TokenReserver)searcher.getDeltaSet(FACTORY);
    }

    TokenReserver() {
    }

    public void reset() {
        this._reservations = new Hashtable();
    }

    @Override
    public double computeEarliestTime() {
        double result = 0.0;
        Enumeration<TokenReservation> enumeration = this._reservations.elements();
        while (enumeration.hasMoreElements()) {
            TokenReservation reservation = enumeration.nextElement();
            double time = reservation.computeEarliestTime();
            if (!(time > result)) continue;
            result = time;
        }
        return result;
    }

    private TokenReservation getReservation(SimulatablePlaceInstance place) {
        if (this._reservations.containsKey(place)) {
            return this._reservations.get(place);
        }
        TokenReservation reservation = new TokenReservation(place);
        this._reservations.put(place, reservation);
        return reservation;
    }

    private void disposeReservation(PlaceInstance place) {
        TokenReservation reservation = this._reservations.get(place);
        if (reservation.isRemovable()) {
            this._reservations.remove(place);
        }
    }

    public synchronized boolean containsRemovableToken(SimulatablePlaceInstance place, Object token, double delay) {
        TokenReservation reservation = this.getReservation(place);
        boolean result = reservation.containsRemovableToken(token, delay);
        this.disposeReservation(place);
        return result;
    }

    public synchronized boolean containsTestableToken(SimulatablePlaceInstance place, Object token) {
        TokenReservation reservation = this.getReservation(place);
        boolean result = reservation.containsTestableToken(token);
        this.disposeReservation(place);
        return result;
    }

    public synchronized boolean removeToken(SimulatablePlaceInstance place, Object token, double time) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation reservation = this.getReservation(place);
        boolean result = reservation.removeToken(token, time);
        this.disposeReservation(place);
        return result;
    }

    public synchronized boolean testToken(SimulatablePlaceInstance place, Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation reservation = this.getReservation(place);
        boolean result = reservation.testToken(token);
        this.disposeReservation(place);
        return result;
    }

    public synchronized void unremoveToken(SimulatablePlaceInstance place, Object token, double time) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation reservation = this.getReservation(place);
        reservation.unremoveToken(token, time);
        this.disposeReservation(place);
    }

    public synchronized void untestToken(SimulatablePlaceInstance place, Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TokenReservation reservation = this.getReservation(place);
        reservation.untestToken(token);
        this.disposeReservation(place);
    }

    public synchronized Collection<Object> getRemovableTokens(SimulatablePlaceInstance place, Object pattern) {
        TokenReservation reservation = this.getReservation(place);
        Collection<Object> result = reservation.getRemovableTokens(pattern);
        this.disposeReservation(place);
        return result;
    }

    public synchronized Collection<Object> getTestableTokens(SimulatablePlaceInstance place, Object pattern) {
        TokenReservation reservation = this.getReservation(place);
        Collection<Object> result = reservation.getTestableTokens(pattern);
        this.disposeReservation(place);
        return result;
    }

    private static class Factory
    implements DeltaSetFactory {
        private Factory() {
        }

        @Override
        public String getCategory() {
            return "de.renew.nets.TokenReserver";
        }

        @Override
        public DeltaSet createDeltaSet() {
            return new TokenReserver();
        }
    }
}

