/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.FIFOPlaceInstance;
import de.renew.net.MultisetPlaceInstance;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TokenSource;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.PlaceEventListenerSet;
import de.renew.net.event.PlaceEventProducer;
import de.renew.unify.Impossible;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Place
implements Serializable,
PlaceEventProducer {
    private static final long serialVersionUID = 5661978821450640374L;
    public static final int MULTISETPLACE = 0;
    public static final int FIFOPLACE = 1;
    private final NetElementID _id;
    private final String _name;
    private String _comment;
    private boolean _trace;
    private final Set<TokenSource> _inscriptions;
    private int _placetype = 0;
    private transient PlaceEventListenerSet _listeners = new PlaceEventListenerSet();

    public Place(Net net, String name, NetElementID id) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._id = id;
        this._name = name;
        this._trace = true;
        this._inscriptions = new HashSet<TokenSource>();
        net.add(this);
    }

    public NetElementID getID() {
        return this._id;
    }

    public String toString() {
        return this._name;
    }

    public void setBehaviour(int behaviour) {
        this._placetype = behaviour;
    }

    protected PlaceInstance makeInstance(NetInstance netInstance, boolean wantInitialTokens) throws Impossible {
        return switch (this._placetype) {
            case 0 -> new MultisetPlaceInstance(netInstance, this, wantInitialTokens);
            case 1 -> new FIFOPlaceInstance(netInstance, this, wantInitialTokens);
            default -> throw new RuntimeException("Illegal place behaviour: " + this._placetype);
        };
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public String getName() {
        return this._name;
    }

    int getPlacetype() {
        return this._placetype;
    }

    public void add(TokenSource tokenSource) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._inscriptions.add(tokenSource);
    }

    public void remove(TokenSource tokenSource) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._inscriptions.remove(tokenSource);
    }

    public Set<TokenSource> getTokenSources() {
        return this._inscriptions;
    }

    public boolean hasInitialTokens() {
        return !this._inscriptions.isEmpty();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream renewOut;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = renewOut = out instanceof RenewObjectOutputStream ? (RenewObjectOutputStream)out : null;
        if (renewOut != null) {
            renewOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (renewOut != null) {
            renewOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this._listeners = new PlaceEventListenerSet();
    }

    @Override
    public void addPlaceEventListener(PlaceEventListener listener) {
        this._listeners.addPlaceEventListener(listener);
    }

    @Override
    public void removePlaceEventListener(PlaceEventListener listener) {
        this._listeners.removePlaceEventListener(listener);
    }

    public PlaceEventListenerSet getListenerSet() {
        return this._listeners;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public String getComment() {
        return this._comment;
    }

    Set<TokenSource> getInscriptions() {
        return this._inscriptions;
    }
}

