/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.NetInstantiation;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.IDRegistry;
import de.renew.net.IDSource;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class NetInstanceImpl
implements DelayedFieldOwner,
NetInstance {
    public static Logger _logger = Logger.getLogger(NetInstanceImpl.class);
    private static final long serialVersionUID = 6136525457931796546L;
    public static boolean _useGlobalIDRegistry = false;
    private Hashtable<Object, Object> _instanceLookup;
    private Net _net;
    private String _netID;
    private transient IDRegistry _registry;

    protected NetInstanceImpl() {
    }

    protected NetInstanceImpl(Net net) throws Impossible {
        this(net, true);
    }

    protected NetInstanceImpl(Net net, boolean wantInitialTokens) throws Impossible {
        this.initNet(net, wantInitialTokens);
    }

    protected void initNet(Net net, boolean wantInitialTokens) throws Impossible {
        if (net == null) {
            throw new Impossible();
        }
        this._net = net;
        this._netID = IDSource.createID();
        this._registry = _useGlobalIDRegistry ? IDRegistry.getInstance() : new IDRegistry();
        this._instanceLookup = new Hashtable();
        for (Place place : net.places()) {
            this._instanceLookup.put(place, place.makeInstance(this, wantInitialTokens));
        }
        for (Transition transition : net.transitions()) {
            this._instanceLookup.put(transition, new TransitionInstance(this, transition));
        }
    }

    public String toString() {
        return String.valueOf(this._net) + "[" + this._netID + "]";
    }

    @Override
    public IDRegistry getRegistry() {
        return this._registry;
    }

    @Override
    public String getID() {
        return this._netID;
    }

    @Override
    public void setID(String id) {
        this._netID = id;
    }

    @Override
    public void earlyConfirmation() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Transaction transaction = TransactionSource.get();
        try {
            transaction.createNet(this);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (Place place : this._net.places()) {
            this.getInstance(place).earlyConfirmation();
        }
    }

    @Override
    public void earlyConfirmationTrace(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        for (Place place : this._net.places()) {
            this.getInstance(place).earlyConfirmationTrace(stepIdentifier);
        }
        NetInstanceList.add(this);
    }

    @Override
    public void lateConfirmation(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new NetInstantiation(this), (NetInstance)this);
        for (Place place : this._net.places()) {
            this.getInstance(place).lateConfirmation(stepIdentifier);
        }
        for (Transition transition : this._net.transitions()) {
            this.getInstance(transition).createConfirmation();
        }
    }

    @Override
    public void createConfirmation(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.earlyConfirmation();
        this.earlyConfirmationTrace(stepIdentifier);
        this.lateConfirmation(stepIdentifier);
    }

    @Override
    public Object getInstance(Object netObject) {
        return this._instanceLookup.get(netObject);
    }

    @Override
    public PlaceInstance getInstance(Place place) {
        return (PlaceInstance)this._instanceLookup.get(place);
    }

    @Override
    public TransitionInstance getInstance(Transition transition) {
        return (TransitionInstance)this._instanceLookup.get(transition);
    }

    @Override
    public Net getNet() {
        return this._net;
    }

    @Override
    public Collection<UplinkProvider> getUplinkProviders(String channel) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<UplinkProvider> result = new ArrayList<UplinkProvider>();
        for (Transition transition : this.getNet().transitions()) {
            TransitionInstance instance = this.getInstance(transition);
            if (!instance.listensToChannel(channel)) continue;
            result.add(instance);
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream renewOut;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream renewObjectOutputStream = renewOut = out instanceof RenewObjectOutputStream ? (RenewObjectOutputStream)out : null;
        if (renewOut != null) {
            renewOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (renewOut != null) {
            renewOut.delayedWriteObject((Object)this._registry, (DelayedFieldOwner)this);
            renewOut.endDomain((Object)this);
        } else {
            out.writeObject(this._registry);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        RenewObjectInputStream renewIn;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        RenewObjectInputStream renewObjectInputStream = renewIn = in instanceof RenewObjectInputStream ? (RenewObjectInputStream)in : null;
        if (renewIn != null) {
            if (renewIn.isCopiousBehaviour()) {
                String oldNetID = this._netID;
                this._netID = IDSource.createID();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Deserialized NetInstance copy: changed id from " + oldNetID + " to " + this._netID + "."));
                }
            }
        } else {
            this._registry = (IDRegistry)in.readObject();
        }
        NetInstanceList.add(this);
    }

    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!(value instanceof IDRegistry)) {
            throw new NotSerializableException("Value of unexpected type given to NetInstanceImpl.reassignField():" + value.getClass().getName() + ".");
        }
        this._registry = (IDRegistry)value;
    }
}

