/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.TokenSource;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;

public class ExpressionTokenSource
implements TokenSource {
    private final Expression _expression;
    private boolean _trace = true;

    public ExpressionTokenSource(Expression expression) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._expression = expression;
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public boolean getTrace() {
        return this._trace;
    }

    @Override
    public Object createToken(VariableMapper mapper) throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object value = this._expression.startEvaluation(mapper, new StateRecorder(), null);
        if (!Unify.isBound(value)) {
            throw new Impossible("Cannot bind expression " + String.valueOf(this._expression));
        }
        return value;
    }
}

