/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.thread;

import de.renew.engine.thread.InheritableSimulationThreadLock;
import de.renew.simulator.api.ISimulationLockExecutor;
import java.util.function.Supplier;

class SimulationLockExecutorImpl
implements ISimulationLockExecutor {
    private static final InheritableSimulationThreadLock LOCK = new InheritableSimulationThreadLock();

    SimulationLockExecutorImpl() {
    }

    public void lock() {
        LOCK.lock();
    }

    public void unlock() {
        LOCK.unlock();
    }

    public void runWithLock(Runnable runnable) {
        LOCK.lock();
        try {
            runnable.run();
        }
        finally {
            LOCK.unlock();
        }
    }

    public <T> T supplyWithLock(Supplier<T> supplier) {
        LOCK.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            LOCK.unlock();
        }
    }
}

