/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.simulator.ConcurrentSimulator;
import de.renew.engine.simulator.ISimulatorFactory;
import de.renew.engine.simulator.NonConcurrentSimulator;
import de.renew.engine.simulator.ParallelSimulator;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.plugin.PropertyHelper;
import de.renew.simulatorontology.simulation.Simulator;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SimulatorFactory
implements ISimulatorFactory {
    private static final Logger LOGGER = Logger.getLogger(SimulatorFactory.class);

    @Override
    public Simulator createSimulator(Properties properties) {
        ConcurrentSimulator simulator;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int simulatorMode = PropertyHelper.getIntProperty((Properties)properties, (String)"de.renew.simulatorMode", (int)1);
        int simulatorMultiplicity = PropertyHelper.getIntProperty((Properties)properties, (String)"de.renew.simulatorMultiplicity", (int)1);
        Class simulatorClass = PropertyHelper.getClassProperty((Properties)properties, (String)"de.renew.simulatorClass", Simulator.class);
        if (simulatorClass != null) {
            LOGGER.info((Object)("Using simulator class " + simulatorClass.getName() + " with " + simulatorMultiplicity + " simulators ..."));
        } else if (simulatorMode == 1) {
            simulatorClass = ConcurrentSimulator.class;
            LOGGER.info((Object)"Using default concurrent simulator ...");
        } else if (simulatorMode == 0 || simulatorMode == -1) {
            simulatorClass = NonConcurrentSimulator.class;
            LOGGER.info((Object)"Using sequential simulator ...");
        } else {
            simulatorClass = ParallelSimulator.class;
            simulatorMultiplicity = simulatorMode;
            if (simulatorMultiplicity < 0) {
                LOGGER.warn((Object)("Using " + -simulatorMultiplicity + " sequential simulators ..."));
            } else {
                LOGGER.warn((Object)("Using " + simulatorMultiplicity + " concurrent simulators ..."));
            }
            LOGGER.warn((Object)"Caution! This is an experimental feature!");
        }
        boolean eagerSimulation = PropertyHelper.getBoolProperty((Properties)properties, (String)"de.renew.eagerSimulation");
        if (eagerSimulation) {
            LOGGER.info((Object)"Using eager simulation mode.");
        }
        try {
            try {
                simulator = (Simulator)simulatorClass.getConstructor(Integer.TYPE, Boolean.TYPE).newInstance(simulatorMultiplicity, !eagerSimulation);
            }
            catch (NoSuchMethodException e) {
                simulator = (Simulator)simulatorClass.getConstructor(Boolean.TYPE).newInstance(!eagerSimulation);
                simulatorMultiplicity = simulator.isSequential() ? 0 : 1;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error((Object)"Encountered exception when trying to instantiate simulator class:", (Throwable)e);
            simulator = new ConcurrentSimulator(!eagerSimulation);
            simulatorClass = ConcurrentSimulator.class;
            simulatorMultiplicity = 1;
        }
        properties.setProperty("de.renew.simulatorClass", simulatorClass.getName());
        properties.setProperty("de.renew.simulatorMultiplicity", Integer.toString(simulatorMultiplicity));
        return simulator;
    }
}

