/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.RandomQueueNode;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.thread.SimulationThreadPool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

class RandomSearchQueue
implements SearchQueueData {
    private final double _time;
    private final List<RandomQueueNode> _elements;
    private final Hashtable<Searchable, RandomQueueNode> _lookup;

    RandomSearchQueue(double time) {
        this._time = time;
        this._elements = new ArrayList<RandomQueueNode>();
        this._lookup = new Hashtable();
    }

    @Override
    public double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this._time;
    }

    @Override
    public void include(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this._lookup.containsKey(searchable)) {
            RandomQueueNode node = new RandomQueueNode(searchable);
            this._elements.add(node);
            this._lookup.put(searchable, node);
        }
    }

    private void discard(RandomQueueNode node) {
        this._elements.remove(node);
        this._lookup.remove(node.getSearchable());
    }

    @Override
    public void exclude(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RandomQueueNode node = this._lookup.get(searchable);
        if (node != null) {
            this.discard(node);
        }
    }

    @Override
    public Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._elements.isEmpty()) {
            return null;
        }
        int pos = ThreadLocalRandom.current().nextInt(this._elements.size());
        RandomQueueNode node = this._elements.get(pos);
        this.discard(node);
        return node.getSearchable();
    }

    @Override
    public Enumeration<Searchable> elements() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this._lookup.keys();
    }

    @Override
    public int size() {
        return this._elements.size();
    }
}

