/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.simulation.StepIdentifier;

public class SimulatorEvent {
    private final StepIdentifier _stepIdentifier;
    private final SimulationEvent _logObject;
    private NetInstance _netInstance = null;
    private Object _netElementInstance = null;

    public SimulatorEvent(SimulationEvent traceObject) throws Exception {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._logObject = traceObject;
        if (SimulatorPlugin.getCurrent() == null) {
            throw new Exception("No simulator running. Cant create Simulator Event.");
        }
        this._stepIdentifier = SimulationManager.getCurrentSimulator().currentStepIdentifier();
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent traceObject) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._stepIdentifier = stepIdentifier;
        this._logObject = traceObject;
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent traceObject, TransitionInstance transitionInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._stepIdentifier = stepIdentifier;
        this._logObject = traceObject;
        this._netElementInstance = transitionInstance;
        if (transitionInstance != null) {
            this._netInstance = transitionInstance.getNetInstance();
        }
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent traceObject, PlaceInstance placeInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._stepIdentifier = stepIdentifier;
        this._logObject = traceObject;
        this._netElementInstance = placeInstance;
        if (placeInstance != null) {
            this._netInstance = placeInstance.getNetInstance();
        }
    }

    public SimulatorEvent(StepIdentifier stepIdentifier, SimulationEvent traceObject, NetInstance netInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._stepIdentifier = stepIdentifier;
        this._logObject = traceObject;
        this._netInstance = netInstance;
    }

    public StepIdentifier getStep() {
        return this._stepIdentifier;
    }

    public SimulationEvent getMessage() {
        return this._logObject;
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        if (this._stepIdentifier != null && this._stepIdentifier.getComponents().length > 0) {
            message.append(this._stepIdentifier);
        }
        message.append(this._logObject.toString());
        return message.toString();
    }

    public Object getNetElementInstance() {
        return this._netElementInstance;
    }

    public NetInstance getNetInstance() {
        return this._netInstance;
    }
}

