/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.Entity;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class SQLDialect {
    protected String convertStringForDB(String string) {
        int pos = ((String)string).indexOf("\\");
        while (pos >= 0) {
            string = ((String)string).substring(0, pos) + "\\\\" + ((String)string).substring(pos + 1);
            pos = ((String)string).indexOf("\\", pos + 2);
        }
        pos = ((String)string).indexOf("'");
        while (pos >= 0) {
            string = ((String)string).substring(0, pos) + "\\'" + ((String)string).substring(pos + 1);
            pos = ((String)string).indexOf("'", pos + 2);
        }
        return string;
    }

    protected String getDeleteString(String tableName, Attribute[] primaryKey, Object[] primaryKeyValue) {
        return this.getDeleteString(tableName, this.getStringOfAndedAttributesAndValues(primaryKey, primaryKeyValue));
    }

    protected String getDeleteString(String tableName, String condition) {
        StringBuilder delete = new StringBuilder();
        delete.append("delete from ");
        delete.append(tableName);
        if (!condition.isEmpty()) {
            delete.append(" where ");
            delete.append(condition);
        }
        return delete.toString();
    }

    protected String getInsertString(String tableName, Attribute[] attributes, Hashtable<String, Object> values, Attribute[] primaryKey) {
        return "insert into " + tableName + " (" + this.getStringOfAttributes(attributes) + ") values (" + this.getStringOfValues(attributes, values) + ")";
    }

    protected String getSelectString(String tableName, Attribute[] attributes) {
        return this.getSelectString(tableName, attributes, null, null);
    }

    protected String getSelectString(String tableName, Attribute[] attributes, String condition) {
        return this.getSelectString(tableName, attributes, condition, null);
    }

    protected String getSelectString(String tableName, Attribute[] attributes, String condition, String order) {
        StringBuilder query = new StringBuilder();
        query.append("select ");
        query.append(this.getStringOfAttributes(attributes));
        query.append(" from ");
        query.append(tableName);
        if (condition != null && !condition.isEmpty()) {
            query.append(" where ");
            query.append(condition);
        }
        if (order != null && !order.isEmpty()) {
            query.append(" order by ");
            query.append(order);
        }
        return query.toString();
    }

    protected String getSelectStringWithPrimaryKey(String tableName, Attribute[] attributes, Attribute[] primaryKey, Object[] primaryKeyValue) {
        return this.getSelectString(tableName, attributes, this.getStringOfAndedAttributesAndValues(primaryKey, primaryKeyValue));
    }

    protected String getStringOfAndedAttributesAndValues(Attribute[] attributes, Hashtable<String, Object> values) {
        StringBuilder result = new StringBuilder();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(" and ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getStringOfAndedAttributesAndValues(Attribute[] attributes, Object[] values) {
        StringBuilder result = new StringBuilder();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(" and ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values[attributeNumber]));
        }
        return result.toString();
    }

    protected String getStringOfAttributeAndValue(Attribute attribute, Object value) {
        return attribute.getName() + "=" + this.getStringOfValue(attribute, value);
    }

    protected String getStringOfAttributes(Attribute[] attributes) {
        StringBuilder result = new StringBuilder();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(attributes[attributeNumber].getName());
        }
        return result.toString();
    }

    protected String getStringOfAttributesAndValues(Attribute[] attributes, Hashtable<String, Object> values) {
        StringBuilder result = new StringBuilder();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getStringOfAttributesAndValues(Attribute[] attributes, Object[] values) {
        StringBuilder result = new StringBuilder();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values[attributeNumber]));
        }
        return result.toString();
    }

    protected String getStringOfAttributesAndValuesExceptPrimaryKey(Attribute[] attributes, Hashtable<String, Object> values, Attribute[] primaryKey) {
        StringBuilder result = new StringBuilder();
        boolean firstAttribute = true;
        for (Attribute attribute : attributes) {
            int primaryKeyAttributeNumber;
            for (primaryKeyAttributeNumber = 0; primaryKeyAttributeNumber < primaryKey.length && !attribute.getName().equals(primaryKey[primaryKeyAttributeNumber].getName()); ++primaryKeyAttributeNumber) {
            }
            if (primaryKeyAttributeNumber < primaryKey.length) continue;
            if (firstAttribute) {
                firstAttribute = false;
            } else {
                result.append(", ");
            }
            result.append(this.getStringOfAttributeAndValue(attribute, values.get(attribute.getName())));
        }
        return result.toString();
    }

    protected String getStringOfValue(Attribute attribute, Object value) {
        String stringValue;
        if (value == null) {
            return "NULL";
        }
        if (value instanceof byte[]) {
            byte[] byteValue = (byte[])value;
            stringValue = new String(byteValue);
        } else {
            stringValue = value.toString();
        }
        return switch (attribute.getType()) {
            case 1, 2 -> stringValue;
            case 3 -> "'" + this.convertStringForDB(stringValue) + "'";
            default -> throw new IllegalStateException("Unknown attribute type");
        };
    }

    protected String getStringOfValues(Attribute[] attributes, Hashtable<String, Object> values) {
        StringBuilder result = new StringBuilder();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(this.getStringOfValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getUpdateString(String tableName, Attribute[] attributes, Hashtable<String, Object> values, Attribute[] primaryKey) {
        StringBuilder update = new StringBuilder();
        update.append("update ");
        update.append(tableName);
        update.append(" set ");
        update.append(this.getStringOfAttributesAndValuesExceptPrimaryKey(attributes, values, primaryKey));
        String condition = this.getStringOfAndedAttributesAndValues(primaryKey, values);
        if (!condition.isEmpty()) {
            update.append(" where ");
            update.append(condition);
        }
        return update.toString();
    }

    protected void setUniquePrimaryKeyValueAfterInsert(Connection connection, Entity entity, Hashtable<String, Object> values) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUniquePrimaryKeyValueBeforeInsert(Connection connection, Entity entity, Hashtable<String, Object> values) throws SQLException {
        Attribute[] primaryKey = entity.getPrimaryKey();
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            for (Attribute attribute : primaryKey) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    String query = "select max(" + attribute.getName() + ") from " + entity.getTableName();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(query);
                    if (!resultSet.next()) continue;
                    entity.setValue(attribute.getName(), resultSet.getInt(1) + 1);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
    }
}

