/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.Transaction;
import de.renew.database.TransactionStrategy;
import java.util.Hashtable;
import java.util.Objects;

public class TransactionSource {
    private static TransactionStrategy _strategy = null;
    private static final Hashtable<Thread, Transaction> TRANSACTIONS = new Hashtable();
    private static final Object HASHTABLE_LOCK = new Object();
    private static final Object STRATEGY_LOCK = new Object();

    private TransactionSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStrategy(TransactionStrategy newStrategy) {
        Object object = STRATEGY_LOCK;
        synchronized (object) {
            _strategy = newStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void perform(NetAction[] createActions, TokenAction[] addActions, TokenAction[] removeActions, NetAction[] deleteActions) throws Exception {
        Object object = STRATEGY_LOCK;
        synchronized (object) {
            if (_strategy != null) {
                _strategy.perform(createActions, addActions, removeActions, deleteActions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void netInstanceDrawingOpened(String netInstanceID) throws Exception {
        Object object = STRATEGY_LOCK;
        synchronized (object) {
            if (_strategy != null) {
                _strategy.netInstanceDrawingOpened(netInstanceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void netInstanceDrawingClosed(String netInstanceID) throws Exception {
        Object object = STRATEGY_LOCK;
        synchronized (object) {
            if (_strategy != null) {
                _strategy.netInstanceDrawingClosed(netInstanceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulationStateChanged(boolean inited, boolean running) throws Exception {
        Object object = STRATEGY_LOCK;
        synchronized (object) {
            if (_strategy != null) {
                _strategy.simulationStateChanged(inited, running);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = HASHTABLE_LOCK;
        synchronized (object) {
            Thread current = Thread.currentThread();
            if (TRANSACTIONS.containsKey(current)) {
                throw new RuntimeException("Nested transactions not supported.");
            }
            TRANSACTIONS.put(Thread.currentThread(), new Transaction(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transaction get() {
        Object object = HASHTABLE_LOCK;
        synchronized (object) {
            Thread current = Thread.currentThread();
            Transaction transaction = TRANSACTIONS.get(current);
            return Objects.requireNonNullElseGet(transaction, () -> new Transaction(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transaction extractCurrentTransaction() {
        Object object = HASHTABLE_LOCK;
        synchronized (object) {
            Thread current = Thread.currentThread();
            Transaction transaction = TRANSACTIONS.get(current);
            if (transaction != null) {
                TRANSACTIONS.remove(current);
            }
            return transaction;
        }
    }

    public static void commit() throws Exception {
        Transaction transaction = TransactionSource.extractCurrentTransaction();
        if (transaction != null) {
            transaction.commit();
        }
    }

    public static void rollback() {
        Transaction transaction = TransactionSource.extractCurrentTransaction();
        if (transaction != null) {
            transaction.rollback();
        }
    }
}

