/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.TransactionSource;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Transaction {
    private static final Logger LOGGER = Logger.getLogger(Transaction.class);
    private final boolean _autoCommit;
    private final Vector<NetAction> _createActions;
    private final Vector<NetAction> _deleteActions;
    private final Vector<TokenAction> _delayedAddActions;
    private final Vector<TokenAction> _addActions;
    private final Vector<TokenAction> _removeActions;

    public Transaction(boolean autoCommit) {
        this._autoCommit = autoCommit;
        this._createActions = new Vector();
        this._deleteActions = new Vector();
        this._delayedAddActions = new Vector();
        this._addActions = new Vector();
        this._removeActions = new Vector();
    }

    public synchronized void createNet(NetInstance instance) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(Transaction.class.getSimpleName() + ": creating net action."));
        }
        this._createActions.addElement(new NetAction(instance));
        if (this._autoCommit) {
            this.commit();
        }
    }

    public synchronized void deleteNet(NetInstance instance) throws Exception {
        this._deleteActions.addElement(new NetAction(instance));
        if (this._autoCommit) {
            this.commit();
        }
    }

    public synchronized void addToken(SimulatablePlaceInstance placeInstance, Object token, double time, boolean automaticInsertion) throws Exception {
        placeInstance.reserve(token);
        TokenAction action = new TokenAction(placeInstance, token, time);
        if (automaticInsertion) {
            this._delayedAddActions.addElement(action);
        }
        this._addActions.addElement(action);
        if (this._autoCommit) {
            this.commit();
        }
    }

    public synchronized void removeToken(SimulatablePlaceInstance placeInstance, Object token, double time) throws Exception {
        placeInstance.reserve(token);
        this._removeActions.addElement(new TokenAction(placeInstance, token, time));
        if (this._autoCommit) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputTokens() {
        for (TokenAction tokenAction : this._delayedAddActions) {
            SimulatablePlaceInstance pi = tokenAction.getPlaceInstance();
            Object token = tokenAction.getToken();
            pi._lock.lock();
            try {
                pi.internallyInsertToken(token, tokenAction.getTime(), false);
            }
            finally {
                pi._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveTokens(Vector<TokenAction> tokenActions) {
        for (TokenAction tokenAction : tokenActions) {
            SimulatablePlaceInstance pi = tokenAction.getPlaceInstance();
            Object token = tokenAction.getToken();
            pi._lock.lock();
            try {
                pi.unreserve(token);
            }
            finally {
                pi._lock.unlock();
            }
        }
    }

    private void unreserveOutputTokens() {
        this.unreserveTokens(this._addActions);
    }

    private void unreserveInputTokens() {
        this.unreserveTokens(this._removeActions);
    }

    private void clear() {
        this._createActions.removeAllElements();
        this._delayedAddActions.removeAllElements();
        this._addActions.removeAllElements();
        this._removeActions.removeAllElements();
        this._deleteActions.removeAllElements();
    }

    public synchronized void commit() throws Exception {
        Object[] ca = new NetAction[this._createActions.size()];
        this._createActions.copyInto(ca);
        Object[] aa = new TokenAction[this._addActions.size()];
        this._addActions.copyInto(aa);
        Object[] ra = new TokenAction[this._removeActions.size()];
        this._removeActions.copyInto(ra);
        Object[] da = new NetAction[this._deleteActions.size()];
        this._deleteActions.copyInto(da);
        TransactionSource.perform((NetAction[])ca, (TokenAction[])aa, (TokenAction[])ra, (NetAction[])da);
        this.outputTokens();
        this.unreserveOutputTokens();
        this.unreserveInputTokens();
        this.clear();
    }

    public synchronized void rollback() {
        this.unreserveOutputTokens();
        this.unreserveInputTokens();
        this.clear();
    }
}

