/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.ISimulationStateRestorer;
import de.renew.database.SetupHelper;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.simulator.api.ISimulationLockExecutor;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulatorontology.simulation.NoSimulationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

class SimulationStateRestorerImpl
implements ISimulationStateRestorer {
    private static final Logger LOGGER = Logger.getLogger(SimulationStateRestorerImpl.class);
    private final ISimulationLockExecutor _lockExecutor;
    private final ISimulationManager _simulationManager;

    SimulationStateRestorerImpl(ISimulationLockExecutor lockExecutor, ISimulationManager simulationManager) {
        this._lockExecutor = lockExecutor;
        this._simulationManager = simulationManager;
    }

    @Override
    public SetupHelper.SimulationState restoreStateFromDatabase() {
        Supplier<SetupHelper.SimulationState> action = () -> {
            try {
                Future<SetupHelper.SimulationState> future = SimulationThreadPool.getCurrent().submitAndWait(() -> SetupHelper.setup(this._simulationManager.getCurrentEnvironment().getProperties()));
                return future.get();
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof NoSimulationException) {
                    NoSimulationException exc = (NoSimulationException)t;
                    throw exc;
                }
                if (t instanceof RuntimeException) {
                    RuntimeException exc = (RuntimeException)t;
                    throw exc;
                }
                if (t instanceof Error) {
                    Error exc = (Error)t;
                    throw exc;
                }
                LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
            }
            return null;
        };
        return (SetupHelper.SimulationState)this._lockExecutor.supplyWithLock(action);
    }
}

