/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ISimulatorFactory;
import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.IDRegistry;
import de.renew.net.INetLookup;
import de.renew.net.Net;
import de.renew.net.loading.NetLoader;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PropertyHelper;
import de.renew.shadowcompiler.DefaultCompiledNetLoader;
import de.renew.shadowcompiler.DefaultShadowNetLoader;
import de.renew.shadowcompiler.SNSFinder;
import de.renew.shadowcompiler.SequentialOnlyExtension;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.simulator.api.IFinderRegistration;
import de.renew.simulator.api.ISimulationLockExecutor;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulator.api.ISimulatorExtensions;
import de.renew.simulatorontology.loading.Finder;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.shadow.ShadowCompilationResult;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.simulatorontology.simulation.NoSimulationException;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulationRunningException;
import de.renew.simulatorontology.simulation.Simulator;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

class SimulationManagerImpl
implements ISimulationManager {
    private static final String PRIORITY_PROP_NAME = "de.renew.simulatorPriority";
    private static final Logger LOGGER = Logger.getLogger(SimulationManagerImpl.class);
    private final ISimulatorExtensions _simulatorExtensions;
    private final IFinderRegistration _finderRegistration;
    private final ISimulatorFactory _simulatorFactory;
    private final INetLookup _netLookup;
    private final ISimulationLockExecutor _simulationLockExecutor;
    private SimulationEnvironment _currentSimulation;
    private SimulationThreadPool _simulationThreadPool = SimulationThreadPool.getCurrent();
    private boolean _virginSimulation;
    private NetLoader _nextNetLoader;

    SimulationManagerImpl(ISimulatorExtensions simulatorExtensions, IFinderRegistration finderRegistration, ISimulatorFactory simulatorFactory, INetLookup netLookup, ISimulationLockExecutor simulationLockExecutor) {
        this._simulatorExtensions = simulatorExtensions;
        this._finderRegistration = finderRegistration;
        this._simulatorFactory = simulatorFactory;
        this._netLookup = netLookup;
        this._simulationLockExecutor = simulationLockExecutor;
        this._finderRegistration.registerDefaultNetFinder((Finder)new SNSFinder());
        this.setDefaultNetLoader();
    }

    public void setupSimulation(Properties properties) {
        Runnable action = () -> SimulationThreadPool.getNew().executeAndWait(() -> {
            if (this.isSimulationSetup()) {
                SimulationThreadPool.discardNew();
                throw new SimulationRunningException();
            }
            this.restartThreadPool();
            Properties activeProperties = new Properties();
            activeProperties.putAll((Map<?, ?>)SimulatorPlugin.getCurrent().getProperties());
            if (properties != null) {
                activeProperties.putAll((Map<?, ?>)properties);
            }
            int maxPriority = PropertyHelper.getIntProperty((Properties)activeProperties, (String)PRIORITY_PROP_NAME, (int)5);
            if (this._simulationThreadPool.getMaxPriority() != maxPriority) {
                this._simulationThreadPool.setMaxPriority(maxPriority);
            }
            SimulatorEventQueue.initialize();
            LOGGER.debug((Object)"SimulationManagerImpl: Setting up simulation.");
            SimulatorPlugin.getCurrent().possiblySetupClassSource(activeProperties);
            this._netLookup.forgetAllNets();
            this._netLookup.setNetLoader(this._nextNetLoader);
            if (this._nextNetLoader instanceof DelayedDelegationNetLoader) {
                LOGGER.debug((Object)"SimulationManagerImpl: Creating default shadow net loader.");
                this._finderRegistration.setNetLoader((ShadowNetLoader)new DefaultShadowNetLoader(activeProperties));
                LOGGER.debug((Object)"SimulationManagerImpl: Configuring delayed net loader.");
                ((DelayedDelegationNetLoader)this._nextNetLoader).setNetLoader(new DefaultCompiledNetLoader(this, this._netLookup, this._finderRegistration.getNetLoader()));
            }
            Simulator simulator = this._simulatorFactory.createSimulator(activeProperties);
            SimulatorExtension[] extensions = this._simulatorExtensions.getSimulationExtensions().toArray(new SimulatorExtension[0]);
            this._currentSimulation = new SimulationEnvironment(simulator, extensions, activeProperties);
            this._virginSimulation = true;
            for (SimulatorExtension activeExtension : extensions) {
                activeExtension.simulationSetup(this._currentSimulation);
            }
            PluginManager.getInstance().blockExit((IPlugin)SimulatorPlugin.getCurrent());
        });
        this._simulationLockExecutor.runWithLock(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShadowNetSystem(ShadowNetSystem shadowNetSystem) throws SyntaxException, NoSimulationException {
        this._simulationLockExecutor.lock();
        try {
            Future<Void> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                ShadowLookup lookup;
                if (!this.isSimulationActive()) {
                    throw new NoSimulationException();
                }
                Objects.requireNonNull(shadowNetSystem, "Missing shadow net system.");
                ShadowNetLoader netLoader = shadowNetSystem.getNetLoader();
                if (netLoader == null && this._finderRegistration.getNetLoader() != null) {
                    LOGGER.debug((Object)"SimulationManagerImpl: Applying default shadow net loader to net system.");
                    shadowNetSystem.setNetLoader(this._finderRegistration.getNetLoader());
                }
                if (this._virginSimulation) {
                    LOGGER.debug((Object)"SimulationManagerImpl: Compiling first net system.");
                    lookup = ShadowNetSystemCompiler.getInstance().compile(shadowNetSystem);
                } else {
                    LOGGER.debug((Object)"SimulationManagerImpl: Adding another net system.");
                    lookup = ShadowNetSystemCompiler.getInstance().compileMore(shadowNetSystem);
                }
                LOGGER.debug((Object)("SimulationManagerImpl: Compilation result lookup: " + String.valueOf(lookup)));
                SequentialOnlyExtension seqEx = SequentialOnlyExtension.lookup(lookup);
                boolean sequentialOnly = seqEx.getSequentialOnly();
                if (sequentialOnly && !this._currentSimulation.getSimulator().isSequential()) {
                    throw new SyntaxException("Some nets need a sequential simulator.");
                }
                this._virginSimulation = false;
                lookup.makeNetsKnown();
                SimulatorExtension[] activeExtensions = this._currentSimulation.getExtensions();
                DefaultShadowCompilationResult result = new DefaultShadowCompilationResult(lookup);
                for (SimulatorExtension activeExtension : activeExtensions) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(SimulatorPlugin.class.getName() + ": Active Extension compile net " + activeExtension.toString()));
                    }
                    activeExtension.netsCompiled((ShadowCompilationResult)result);
                }
                return null;
            });
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)"Simulation ended");
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof SyntaxException) {
                SyntaxException exc = (SyntaxException)t;
                throw exc;
            }
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            this._simulationLockExecutor.unlock();
        }
    }

    public Simulator getCurrentSimulator() {
        if (this.isSimulationSetup()) {
            return this._currentSimulation.getSimulator();
        }
        return null;
    }

    public Properties getSimulationProperties() {
        if (this.isSimulationSetup()) {
            return this._currentSimulation.getProperties();
        }
        return null;
    }

    public SimulationEnvironment getCurrentEnvironment() {
        return this._currentSimulation;
    }

    public void terminateSimulation() {
        Runnable action = () -> SimulationThreadPool.getCurrent().executeAndWait(() -> {
            SimulatorExtension[] exts;
            if (this._currentSimulation == null) {
                return;
            }
            LOGGER.debug((Object)"SimulationManagerImpl: Stopping simulation.");
            for (SimulatorExtension ext : exts = this._currentSimulation.getExtensions()) {
                ext.simulationTerminating();
            }
            this._currentSimulation.getSimulator().terminateRun();
            for (SimulatorExtension ext : exts = this._currentSimulation.getExtensions()) {
                ext.simulationTerminated();
            }
            SearchQueue.reset(0.0);
            IDRegistry.reset();
            this._netLookup.forgetAllNets();
            PluginManager.getInstance().exitOk((IPlugin)SimulatorPlugin.getCurrent());
            this._currentSimulation = null;
            this._finderRegistration.setNetLoader(null);
        });
        this._simulationLockExecutor.runWithLock(action);
    }

    public boolean isSimulationActive() {
        return this.isSimulationSetup() && this._currentSimulation.getSimulator().isActive();
    }

    public boolean isSimulationSetup() {
        return this._currentSimulation != null && this._currentSimulation.getSimulator() != null;
    }

    public synchronized void setDefaultNetLoader() {
        this.setNetLoader(new DelayedDelegationNetLoader());
    }

    public void cleanup() {
        this.setNetLoader(null);
        SimulationThreadPool.cleanup();
        this._simulatorExtensions.cleanup();
    }

    private void setNetLoader(NetLoader netLoader) {
        LOGGER.debug((Object)("SimulationManagerImpl: Configuring net loader " + String.valueOf(netLoader) + "."));
        this._nextNetLoader = netLoader;
    }

    private void restartThreadPool() {
        SimulationThreadPool.cleanup();
        this._simulationThreadPool = SimulationThreadPool.getSimulationThreadPool();
    }

    private static final class DelayedDelegationNetLoader
    implements NetLoader {
        private NetLoader _netLoader = null;

        private DelayedDelegationNetLoader() {
        }

        public void setNetLoader(NetLoader netLoader) {
            this._netLoader = netLoader;
        }

        @Override
        public Net loadNet(String netName) throws NetNotFoundException {
            if (this._netLoader == null) {
                throw new NetNotFoundException("No net loader configured.");
            }
            return this._netLoader.loadNet(netName);
        }
    }

    private static final class DefaultShadowCompilationResult
    implements ShadowCompilationResult {
        private final ShadowLookup _lookup;

        DefaultShadowCompilationResult(ShadowLookup lookup) {
            this._lookup = lookup;
        }

        public boolean containsNewlyCompiledNets() {
            return this._lookup.containsNewlyCompiledNets();
        }

        public Collection<String> allNewlyCompiledNetNames() {
            ArrayList<String> result = new ArrayList<String>();
            this._lookup.allNewlyCompiledNetNames().forEachRemaining(result::add);
            return result;
        }
    }
}

