/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ioontology.importing;

import CH.ifa.draw.io.CombinationFileFilter;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.MultiExtensionFileFilter;
import de.renew.ioontology.MultiExtensionFileFilterImpl;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.ioontology.importing.ImportFormatAbstract;
import de.renew.ioontology.importing.ImportFormatMulti;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class ImportFormatMultiAbstract<T>
extends ImportFormatAbstract<T>
implements ImportFormatMulti<T> {
    private final List<ImportFormat<T>> _formats = new LinkedList<ImportFormat<T>>();

    public ImportFormatMultiAbstract(String name, String filterName) {
        super(name, new MultiExtensionFileFilterImpl(filterName));
    }

    private MultiExtensionFileFilter multiFileFilter() {
        MultiExtensionFileFilter result = (MultiExtensionFileFilter)this.fileFilter();
        Objects.requireNonNull(result, "Failure in ImportFormatAbstract: result == null");
        return result;
    }

    protected void addFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter comFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : comFileFilter.getFileFilters()) {
                this.addFileFilter(fileFilter2);
            }
        } else if (fileFilter instanceof MultiExtensionFileFilter) {
            MultiExtensionFileFilter multiFilter = (MultiExtensionFileFilter)fileFilter;
            for (ExtensionFileFilter extensionFileFilter : multiFilter.getFileFilters()) {
                this.addFileFilter(extensionFileFilter);
            }
        } else if (fileFilter instanceof ExtensionFileFilter) {
            this.multiFileFilter().add((ExtensionFileFilter)fileFilter);
        }
    }

    protected void removeFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter comFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : comFileFilter.getFileFilters()) {
                this.removeFileFilter(fileFilter2);
            }
        } else if (fileFilter instanceof MultiExtensionFileFilter) {
            MultiExtensionFileFilter multiFilter = (MultiExtensionFileFilter)fileFilter;
            for (ExtensionFileFilter extensionFileFilter : multiFilter.getFileFilters()) {
                this.removeFileFilter(extensionFileFilter);
            }
        } else if (fileFilter instanceof ExtensionFileFilter) {
            this.multiFileFilter().remove((ExtensionFileFilter)fileFilter);
        }
    }

    @Override
    public void addImportFormat(ImportFormat<T> format) {
        Objects.requireNonNull(format, "Failure in ImportFormatMultiAbstract: format == null");
        this._formats.add(format);
        this.addFileFilter(format.fileFilter());
    }

    @Override
    public List<ImportFormat<T>> getImportFormats() {
        return this._formats;
    }

    @Override
    public void removeImportFormat(ImportFormat<T> format) {
        Objects.requireNonNull(format, "Failure in ImportFormatMultiAbstract: format == null");
        this.removeFileFilter(format.fileFilter());
        this._formats.remove(format);
    }

    @Override
    public List<T> importFiles(URL[] paths) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        for (int posfiles = 0; posfiles < paths.length; ++posfiles) {
            List<ImportFormat<T>> formats = this.getImportFormats();
            for (int posformat = 0; posformat < formats.size(); ++posformat) {
                if (!formats.get(posformat).canImport(paths[posfiles])) continue;
                URL[] urls = new URL[]{paths[posfiles]};
                result.addAll(formats.get(posformat).importFiles(urls));
            }
        }
        return result;
    }
}

