/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ioontology;

import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileType;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.Objects;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilterImpl
extends FileFilter
implements ExtensionFileFilter {
    private final String _extension;
    private String _description;

    public ExtensionFileFilterImpl(String extension, String description) {
        this._extension = extension;
        this._description = description;
    }

    public ExtensionFileFilterImpl(FileType fileType) {
        this._extension = fileType.getExtension();
        this._description = fileType.getDescription();
    }

    @Override
    public final boolean accept(File f) {
        if (f == null || f.isHidden() || f.getName().startsWith(".")) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String extension = StringUtil.getExtension((String)f.getName());
        return this._extension.equals(extension);
    }

    @Override
    public final String getDescription() {
        return this._description;
    }

    @Override
    public final String getExtension() {
        return this._extension;
    }

    @Override
    public final void setDescription(String string) {
        this._description = string;
    }

    public final boolean equals(Object o) {
        return o instanceof ExtensionFileFilterImpl && Objects.equals(((ExtensionFileFilterImpl)o).getExtension(), this.getExtension());
    }

    public final int hashCode() {
        return Objects.hashCode(this.getExtension());
    }
}

