/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.ui.impl.menus;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.util.CommandMenu;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.impl.drawings.DrawingExportFormatHolder;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormatMulti;
import de.renew.draw.ui.api.ApplicationApi;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.MultiExtensionFileFilter;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.exporting.ExportFormatListener;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ExportMenuHolder {
    private static final Logger LOGGER = Logger.getLogger(ExportMenuHolder.class);
    private static final String APPENDIX_11 = " current drawing ...";
    private static final String APPENDIX_N1 = " all drawings (N to 1) ...";
    private static final String APPENDIX_NN = " all drawings (N to N)";
    private final CommandMenu _exportMenu = new CommandMenu("Export");
    private final CommandMenu _exportMenu11;
    private final CommandMenu _exportMenuNN;
    private final CommandMenu _exportMenuN1;

    public ExportMenuHolder() {
        this._exportMenu.putClientProperty("ch.ifa.draw.menu.id", "de.renew.draw.ui.menu.export");
        this._exportMenu11 = new CommandMenu("Export current drawing");
        this._exportMenuNN = new CommandMenu("Export all drawings (single file each)");
        this._exportMenuN1 = new CommandMenu("Export all drawings (merged file)");
        this.buildExportAll();
        this._exportMenu.add(this._exportMenu11);
        this._exportMenu.add(this._exportMenuNN);
        this._exportMenu.add(this._exportMenuN1);
        DrawingExportFormatHolder.getInstance().addExportFormatListener(this.createExportFormatListener());
    }

    public JMenu getExportMenu() {
        return this._exportMenu;
    }

    private List<ExportFormat<Drawing>> getExportFormats() {
        return DrawingExportFormatHolder.getInstance().getExportFormats();
    }

    private FileFilter[] fileFilterExport(Drawing drawing) {
        ArrayList<FileFilter[]> fileFilters = new ArrayList<FileFilter[]>();
        List<ExportFormat<Drawing>> formats = this.getExportFormats();
        for (ExportFormat<Drawing> format : formats) {
            if (!format.canExportObject(drawing)) continue;
            fileFilters.add(ExportMenuHolder.buildFileFilter(format));
        }
        ArrayList<FileFilter> allFileFilters = new ArrayList<FileFilter>();
        allFileFilters.add(new NoFileFilter());
        for (FileFilter[] element : fileFilters) {
            for (int pos = 0; pos < element.length; ++pos) {
                FileFilter current = element[pos];
                boolean exists = false;
                for (int pos2 = 0; pos2 <= pos; ++pos2) {
                    if (!current.equals(allFileFilters.get(pos2))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                allFileFilters.add(current);
            }
        }
        return allFileFilters.toArray(new FileFilter[0]);
    }

    private static FileFilter[] buildFileFilter(ExportFormat<?> exportFormat) {
        FileFilter filter = exportFormat.fileFilter();
        ArrayList<FileFilter> list = new ArrayList<FileFilter>();
        if (filter instanceof CombinationFileFilter) {
            CombinationFileFilter comFilter = (CombinationFileFilter)filter;
            list.addAll(comFilter.getFileFilters());
        } else if (filter instanceof MultiExtensionFileFilter) {
            MultiExtensionFileFilter multiFilter = (MultiExtensionFileFilter)filter;
            list.addAll(multiFilter.getFileFilters());
        } else {
            list.add(filter);
        }
        return list.toArray(new FileFilter[0]);
    }

    private void buildExportAll() {
        AbstractCommand command = new AbstractCommand("Export current drawing (any type)..."){

            @Override
            public void execute() {
                ExportMenuHolder.this.executeExportAll();
            }

            @Override
            public boolean isExecutable() {
                return super.isExecutable() && DrawPlugin.getGui() != null && !StorableApi.isDrawingNullDrawing(EditorApi.getCurrentDrawing());
            }
        };
        this._exportMenu.add(command);
    }

    private void executeExportAll() {
        Drawing currentDrawing = EditorApi.getCurrentDrawing();
        if (StorableApi.isDrawingNullDrawing(currentDrawing)) {
            ApplicationApi.showStatus("no drawing");
            return;
        }
        File path = ExportMenuHolder.getIOHelper().getSaveFile(null, this.fileFilterExport(currentDrawing), currentDrawing);
        if (path != null) {
            Object choice;
            ArrayList<ExportFormat<Drawing>[]> list = new ArrayList<ExportFormat<Drawing>[]>();
            for (int pos = 0; pos < this.getExportFormats().size(); ++pos) {
                ExportFormat<Drawing>[] formats = this.getExportFormats().get(pos).canExport(path);
                if (formats.length <= 0) continue;
                list.add(formats);
            }
            Iterator formatsIter = list.iterator();
            ArrayList<ExportFormat> allFormats = new ArrayList<ExportFormat>();
            while (formatsIter.hasNext()) {
                ExportFormat[] formatArray;
                for (ExportFormat exportFormat : formatArray = (ExportFormat[])formatsIter.next()) {
                    if (!exportFormat.canExportObject(currentDrawing)) continue;
                    if (new NoFileFilter().equals(exportFormat.fileFilter())) {
                        if (!"".equals(StringUtil.getExtension((String)path.getPath()))) continue;
                        allFormats.add(exportFormat);
                        continue;
                    }
                    allFormats.add(exportFormat);
                }
            }
            ExportFormat format = null;
            if (allFormats.size() == 1) {
                format = (ExportFormat)allFormats.get(0);
            } else if (allFormats.size() > 1 && (choice = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, allFormats.toArray(), allFormats.get(0))) != null) {
                format = (ExportFormat)choice;
            }
            if (format != null) {
                this.saveDrawing(currentDrawing, format, path);
            } else {
                ApplicationApi.showStatus("no ExportFormat");
            }
        }
    }

    static void saveDrawings(List<Drawing> drawings, ExportFormat<Drawing> format, File path, StatusDisplayer displ) {
        try {
            Drawing[] array = drawings.toArray(new Drawing[0]);
            format.export((Drawing[])array, path);
            displ.showStatus("Exported " + path.getPath() + ".");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            displ.showStatus(e.toString());
            LOGGER.debug((Object)(ExportMenuHolder.class.getSimpleName() + ": "), (Throwable)e);
        }
    }

    private void saveDrawings(Enumeration<Drawing> drawings, ExportFormat<Drawing> format) {
        try {
            ArrayList<Drawing> drawingList = new ArrayList<Drawing>();
            while (drawings.hasMoreElements()) {
                Drawing drawing = drawings.nextElement();
                if (drawing.getFilename() == null) {
                    DrawPlugin.getGui().saveDrawingAs(drawing);
                    continue;
                }
                drawingList.add(drawing);
            }
            Drawing[] drawingArray = drawingList.toArray(new Drawing[0]);
            File[] paths = new File[drawingArray.length];
            for (int pos = 0; pos < drawingArray.length; ++pos) {
                String name = drawingArray[pos].getName();
                File path = drawingArray[pos].getFilename().getCanonicalFile();
                String pathString = path.getParent() + File.separator + name;
                paths[pos] = DrawingFileHelper.checkAndAddExtension(new File(pathString), this.getExtensionFileFilter(format));
            }
            if (drawingArray.length > 0) {
                format.exportAll((Drawing[])drawingArray, paths);
                ApplicationApi.showStatus("Exported.");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ApplicationApi.showStatus(e.toString());
        }
    }

    private ExtensionFileFilter getExtensionFileFilter(final ExportFormat<?> exportFormat) {
        if (exportFormat == null || exportFormat.fileFilter() == null) {
            return null;
        }
        FileFilter fileFilter = exportFormat.fileFilter();
        if (fileFilter instanceof MultiExtensionFileFilter) {
            final MultiExtensionFileFilter mff = (MultiExtensionFileFilter)fileFilter;
            return new ExtensionFileFilter(){

                @Override
                public String getExtension() {
                    return mff.getPreferredFileFilter().getExtension();
                }

                @Override
                public boolean accept(File file) {
                    return mff.accept(file);
                }

                @Override
                public String getDescription() {
                    return mff.getDescription();
                }

                @Override
                public void setDescription(String description) {
                    mff.setDescription(description);
                }
            };
        }
        fileFilter = exportFormat.fileFilter();
        if (fileFilter instanceof ExtensionFileFilter) {
            ExtensionFileFilter eff = (ExtensionFileFilter)fileFilter;
            return eff;
        }
        return new ExtensionFileFilter(){

            @Override
            public String getExtension() {
                return "";
            }

            @Override
            public boolean accept(File file) {
                return exportFormat.fileFilter().accept(file);
            }

            @Override
            public String getDescription() {
                return exportFormat.fileFilter().getDescription();
            }

            @Override
            public void setDescription(String description) {
                exportFormat.fileFilter().setDescription(description);
            }
        };
    }

    static void saveDrawing(Drawing drawing, ExportFormat<Drawing> format, File path, StatusDisplayer sd) {
        try {
            File pathResult = format.export(drawing, path);
            sd.showStatus("Exported " + pathResult.getPath() + ".");
        }
        catch (Exception e) {
            sd.showStatus(e.getMessage());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveDrawing(Drawing drawing, ExportFormat<Drawing> format, File path) {
        try {
            File pathResult = format.export(drawing, path);
            ApplicationApi.showStatus("Exported " + pathResult.getPath() + ".");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ApplicationApi.showStatus(e.toString());
        }
    }

    private void buildExportFormat(ExportFormat<Drawing> exportFormat, CommandMenu parent11, CommandMenu parentNN, CommandMenu parentN1) {
        if (exportFormat instanceof AbstractDrawingExportFormatMulti) {
            AbstractDrawingExportFormatMulti drawingExportFormatMulti = (AbstractDrawingExportFormatMulti)exportFormat;
            List formats = drawingExportFormatMulti.getExportFormats();
            String name = drawingExportFormatMulti.formatName();
            CommandMenu menu11 = new CommandMenu(name);
            CommandMenu menuNN = new CommandMenu(name);
            CommandMenu menuN1 = new CommandMenu(name);
            for (ExportFormat<Drawing> exportFormat2 : formats) {
                this.buildExportFormat(exportFormat2, menu11, menuNN, menuN1);
            }
            parent11.add(menu11);
            parent11.addSeparator();
            parentNN.add(menuNN);
            parentNN.addSeparator();
            parentN1.add(menuN1);
            parentN1.addSeparator();
        } else {
            this.generateCommands(exportFormat, parent11, parentNN, parentN1);
        }
    }

    private void generateCommands(ExportFormat<Drawing> format, CommandMenu menu11, CommandMenu menuNN, CommandMenu menuN1) {
        AbstractCommand command11 = this.createDrawingExportFormatCommand(format, APPENDIX_11, this::executeExport1to1, this::isExecutable1to1);
        if (format.getShortCut() == -1) {
            menu11.add(command11);
        } else if (format.getModifier() == -1) {
            menu11.add(command11, format.getShortCut());
        } else {
            menu11.add(command11, format.getShortCut(), format.getModifier());
        }
        AbstractCommand commandNN = this.createDrawingExportFormatCommand(format, APPENDIX_NN, this::executeNtoN, this::isExecutableNtoN);
        menuNN.add(commandNN);
        if (format.canExportNto1()) {
            AbstractCommand commandN1 = this.createDrawingExportFormatCommand(format, APPENDIX_N1, this::executeNto1, this::isExecutableNto1);
            menuN1.add(commandN1);
        }
    }

    private void executeExport1to1(ExportFormat<Drawing> format) {
        Drawing drawing = EditorApi.getCurrentDrawing();
        if (drawing != null && !StorableApi.isDrawingNullDrawing(drawing)) {
            if (format.forceGivenName()) {
                if (drawing.getFilename() != null) {
                    try {
                        String fileNameText = drawing.getFilename().getCanonicalPath() + drawing.getName();
                        fileNameText = StringUtil.getPath((String)fileNameText) + File.separator + drawing.getName();
                        File file = new File(fileNameText);
                        this.saveDrawing(drawing, format, file);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Could not create export file: ");
                        LOGGER.debug((Object)"Could not create export file: ", (Throwable)e);
                    }
                }
            } else {
                File path = ExportMenuHolder.getIOHelper().getSaveFile(null, new FileFilter[]{format.fileFilter()}, drawing);
                if (path != null) {
                    ApplicationApi.showStatus("Exporting " + String.valueOf(path) + " ...");
                    this.saveDrawing(drawing, format, path);
                }
            }
        } else {
            ApplicationApi.showStatus("no drawing");
        }
        EditorApi.toolDone();
    }

    private boolean isExecutable1to1(ExportFormat<Drawing> format) {
        return DrawPlugin.getGui() != null && !StorableApi.isDrawingNullDrawing(EditorApi.getCurrentDrawing()) && format.canExportObject(EditorApi.getCurrentDrawing());
    }

    private void executeNto1(ExportFormat<Drawing> format) {
        Enumeration<Drawing> drawings = EditorApi.getCurrentDrawings();
        if (drawings != null) {
            if (drawings.hasMoreElements()) {
                File path = ExportMenuHolder.getIOHelper().getSaveFile(null, new FileFilter[]{format.fileFilter()}, drawings.nextElement());
                if (path != null) {
                    ApplicationApi.showStatus("Exporting " + String.valueOf(path) + " ...");
                    ExportMenuHolder.saveDrawings(Collections.list(EditorApi.getCurrentDrawings()), format, path, DrawPlugin.getGui());
                }
            } else {
                ApplicationApi.showStatus("no drawing");
            }
        }
        EditorApi.toolDone();
        ApplicationApi.showStatus("export");
    }

    private boolean isExecutableNto1(ExportFormat<Drawing> format) {
        if (DrawPlugin.getGui() == null || StorableApi.isDrawingNullDrawing(EditorApi.getCurrentDrawing())) {
            return false;
        }
        Enumeration<Drawing> drawings = EditorApi.getCurrentDrawings();
        while (drawings.hasMoreElements()) {
            Drawing drawing = drawings.nextElement();
            if (format.canExportObject(drawing)) continue;
            return false;
        }
        return true;
    }

    private void executeNtoN(ExportFormat<Drawing> format) {
        ApplicationApi.showStatus("Exporting...");
        Enumeration<Drawing> drawings = EditorApi.getCurrentDrawings();
        if (drawings != null) {
            if (drawings.hasMoreElements()) {
                this.saveDrawings(drawings, format);
            } else {
                ApplicationApi.showStatus("no drawing");
            }
        }
        EditorApi.toolDone();
        ApplicationApi.showStatus("export");
    }

    private boolean isExecutableNtoN(ExportFormat<Drawing> format) {
        if (DrawPlugin.getGui() == null || StorableApi.isDrawingNullDrawing(EditorApi.getCurrentDrawing())) {
            return false;
        }
        Enumeration<Drawing> drawings = EditorApi.getCurrentDrawings();
        while (drawings.hasMoreElements()) {
            Drawing drawing = drawings.nextElement();
            if (format.canExportObject(drawing)) continue;
            return false;
        }
        return true;
    }

    void addExportFormat(ExportFormat<Drawing> exportFormat) {
        LOGGER.debug((Object)(String.valueOf(this.getClass()) + ": adding export format " + String.valueOf(exportFormat)));
        this.buildExportFormat(exportFormat, this._exportMenu11, this._exportMenuNN, this._exportMenuN1);
    }

    void removeExportFormat(ExportFormat<Drawing> exportFormat) {
        Component[] ele;
        LOGGER.debug((Object)(String.valueOf(this.getClass()) + ": removing export format " + String.valueOf(exportFormat)));
        for (Component component : ele = this._exportMenu.getMenuComponents()) {
            JMenuItem item;
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getText().equals(exportFormat.formatName())) continue;
            this._exportMenu.remove(item);
        }
        this.removeExportFormatFromMenu(exportFormat, this._exportMenu11, APPENDIX_11);
        this.removeExportFormatFromMenu(exportFormat, this._exportMenuN1, APPENDIX_N1);
        this.removeExportFormatFromMenu(exportFormat, this._exportMenuNN, APPENDIX_NN);
    }

    private void removeExportFormatFromMenu(ExportFormat<?> format, CommandMenu menu, String appendix) {
        Component[] ele;
        for (Component component : ele = menu.getMenuComponents()) {
            JMenuItem item;
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getText().equals(format.formatName() + appendix)) continue;
            menu.remove(item);
        }
    }

    private static IOHelper getIOHelper() {
        return Objects.requireNonNull(DrawPlugin.getCurrent()).getIOHelper();
    }

    private AbstractCommand createDrawingExportFormatCommand(final ExportFormat<Drawing> format, String nameAppend, final Consumer<ExportFormat<Drawing>> executor, final Predicate<ExportFormat<Drawing>> verifier) {
        return new AbstractCommand(format.formatName() + nameAppend){

            @Override
            public void execute() {
                executor.accept(format);
            }

            @Override
            public boolean isExecutable() {
                return verifier.test(format);
            }
        };
    }

    private ExportFormatListener<Drawing> createExportFormatListener() {
        return new ExportFormatListener<Drawing>(){

            @Override
            public void exportFormatAdded(ExportFormat<Drawing> addedFormat) {
                ExportMenuHolder.this.addExportFormat(addedFormat);
            }

            @Override
            public void exportFormatRemoved(ExportFormat<Drawing> removedFormat) {
                ExportMenuHolder.this.removeExportFormat(removedFormat);
            }
        };
    }
}

