/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.ui.api;

import de.renew.draw.ui.api.services.MenuService;
import de.renew.draw.ui.impl.services.MenuServiceImpl;
import de.renew.draw.ui.ontology.MenuSectionPosition;
import de.renew.draw.ui.ontology.MenuSeparatorFactory;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public final class MenuApi {
    private static MenuService _service = new MenuServiceImpl();
    public static final String ID_PROPERTY = "ch.ifa.draw.menu.id";

    private MenuApi() {
    }

    public static void registerMenu(String parentMenu, JMenuItem menuToRegister) {
        _service.registerMenu(parentMenu, menuToRegister);
    }

    public static void registerMenu(String parentMenu, JMenuItem menuToRegister, String id) {
        _service.registerMenu(parentMenu, menuToRegister, id);
    }

    public static void registerMenu(String parentMenu, JMenuItem menuToRegister, int requestedSection, MenuSectionPosition itemPosition) {
        _service.registerMenu(parentMenu, menuToRegister, requestedSection, itemPosition);
    }

    public static void unregisterMenu(JMenuItem menuToUnregister) {
        if (SwingUtilities.isEventDispatchThread()) {
            _service.unregisterMenu(menuToUnregister);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> _service.unregisterMenu(menuToUnregister));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute unregisterMenu()", e);
            }
        }
    }

    public static void unregisterMenu(String id) {
        _service.unregisterMenu(id);
    }

    public static JMenu createTopLevelMenu(String parentMenu, int section) {
        return _service.createTopLevelMenu(parentMenu, section);
    }

    public static JMenuItem createMenuItem(String name, int shortcut, Runnable action) {
        return _service.createMenuItem(name, shortcut, action);
    }

    public static JMenuItem createMenuItem(String name, Runnable action) {
        return _service.createMenuItem(name, action);
    }

    public static MenuSeparatorFactory createMenuSeparatorFactory(String id) {
        return _service.createMenuSeparatorFactory(id);
    }

    public static JMenuItem createMenuSeparator(String id) {
        return _service.createMenuSeparator(id);
    }

    public static String getMenuNamePluginsMenu() {
        return _service.getMenuNamePluginsMenu();
    }

    public static String getMenuNamePlatformsMenu() {
        return _service.getMenuNamePlatformsMenu();
    }

    public static String getMenuNameFileMenu() {
        return _service.getMenuNameFileMenu();
    }

    public static String getMenuNameEditMenu() {
        return _service.getMenuNameEditMenu();
    }

    public static String getMenuNameAttributesMenu() {
        return _service.getMenuNameAttributesMenu();
    }

    public static String getMenuNameLayoutMenu() {
        return _service.getMenuNameLayoutMenu();
    }

    public static String getMenuNameToolsMenu() {
        return _service.getMenuNameToolsMenu();
    }

    public static String getMenuNamePaoseMenu() {
        return _service.getMenuNamePaoseMenu();
    }

    public static String getMenuNameHelpMenu() {
        return _service.getMenuNameHelpMenu();
    }

    public static String getWindowsCategoryNameTools() {
        return _service.getWindowsCategoryNameTools();
    }

    public static void registerWindowsMenuDialog(String category, Dialog dialog) {
        _service.registerWindowsMenuDialog(category, dialog);
    }

    public static void unregisterWindowsMenuDialog(Dialog dialog) {
        _service.unregisterWindowsMenuDialog(dialog);
    }

    public static void registerWindowsMenuFrame(String category, Frame frame) {
        _service.registerWindowsMenuFrame(category, frame);
    }

    public static void unregisterWindowsMenuFrame(Frame frame) {
        _service.unregisterWindowsMenuFrame(frame);
    }

    public static void registerWindowsMenuItem(JMenuItem menuItem) {
        _service.registerWindowsMenuItem(menuItem);
    }

    public static void unregisterWindowsMenuItem(JMenuItem menuItem) {
        _service.unregisterWindowsMenuItem(menuItem);
    }
}

