/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.CommandMenuItem;
import de.renew.draw.ui.ontology.AbstractCommand;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import org.apache.log4j.Logger;

public class CommandMenu
extends JMenu
implements ActionListener {
    public static Logger logger = Logger.getLogger(CommandMenu.class);
    private final Map<AbstractCommand, CommandMenuItem> _commandItems = new HashMap<AbstractCommand, CommandMenuItem>();

    public CommandMenu(String name) {
        super(name);
        this.checkEnabled();
    }

    @Override
    public synchronized JMenuItem add(JMenuItem item) {
        if (item instanceof CommandMenuItem) {
            CommandMenuItem citem = (CommandMenuItem)item;
            AbstractCommand command = citem.getCommand();
            if (this._commandItems.containsKey(command)) {
                throw new IllegalArgumentException("Cannot add command " + command.getCommandName() + ": it already exists in the menu.");
            }
            this._commandItems.put(command, citem);
            citem.addActionListener(this);
            JMenuItem result = super.add(citem);
            this.checkEnabled();
            return result;
        }
        return super.add(item);
    }

    @Override
    public synchronized Component add(Component item, int position) {
        if (item instanceof CommandMenuItem) {
            CommandMenuItem citem = (CommandMenuItem)item;
            AbstractCommand command = citem.getCommand();
            if (this._commandItems.containsKey(command)) {
                throw new IllegalArgumentException("Cannot add command " + command.getCommandName() + ": it already exists in the menu.");
            }
            this._commandItems.put(command, citem);
            citem.addActionListener(this);
            Component result = super.add(item, position);
            this.checkEnabled();
            return result;
        }
        return super.add(item, position);
    }

    public synchronized void add(AbstractCommand command) {
        this.add(new CommandMenuItem(command));
    }

    public synchronized void add(AbstractCommand command, int shortcut) {
        this.add(new CommandMenuItem(command, shortcut));
    }

    public synchronized void add(AbstractCommand command, int shortcut, int modifier) {
        this.add(new CommandMenuItem(command, shortcut, modifier));
    }

    public synchronized void remove(AbstractCommand command) {
        CommandMenuItem citem = this._commandItems.get(command);
        if (citem == null) {
            throw new IllegalArgumentException("Cannot remove command " + command.getCommandName() + ": it does not exist in the menu.");
        }
        this.remove(citem);
    }

    @Override
    public synchronized void remove(JMenuItem item) {
        if (item instanceof CommandMenuItem) {
            CommandMenuItem citem = (CommandMenuItem)item;
            AbstractCommand command = citem.getCommand();
            if (this._commandItems.get(command) != item) {
                throw new IllegalArgumentException("Cannot remove item for command " + command.getCommandName() + ": the item is insconsistent with the menu.");
            }
            this._commandItems.remove(command);
            citem.dispose();
            citem.removeActionListener(this);
        } else if (item instanceof CommandMenu) {
            CommandMenu menu = (CommandMenu)item;
            for (MenuElement elem : menu.getPopupMenu().getSubElements()) {
                if (elem instanceof JMenuItem) {
                    JMenuItem sub = (JMenuItem)elem;
                    menu.remove(sub);
                    continue;
                }
                if (!(elem instanceof JPopupMenu.Separator)) continue;
                JPopupMenu.Separator sep = (JPopupMenu.Separator)((Object)elem);
                menu.remove(sep);
            }
            menu.ui.uninstallUI(menu);
        }
        super.remove(item);
    }

    public synchronized boolean checkEnabled() {
        boolean menuEnabled = false;
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            boolean enabled;
            Component item = this.getMenuComponent(i);
            if (item == null) {
                return false;
            }
            if (item instanceof CommandMenuItem) {
                enabled = ((CommandMenuItem)item).getCommand().isExecutable();
                item.setEnabled(enabled);
                menuEnabled |= enabled;
                continue;
            }
            if (item instanceof CommandMenu) {
                enabled = ((CommandMenu)item).checkEnabled();
                item.setEnabled(enabled);
                menuEnabled |= enabled;
                continue;
            }
            if (item instanceof JSeparator) continue;
            menuEnabled |= item.isEnabled();
        }
        return menuEnabled;
    }

    public synchronized void updateCommandText() {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Component item = this.getMenuComponent(i);
            if (item == null) {
                return;
            }
            if (item instanceof CommandMenuItem) {
                AbstractCommand command = ((CommandMenuItem)item).getCommand();
                String commandText = command.getCommandName();
                String text = ((AbstractButton)item).getText();
                if (text == null || commandText == null || text.equals(commandText)) continue;
                ((AbstractButton)item).setText(commandText);
                continue;
            }
            if (!(item instanceof CommandMenu)) continue;
            ((CommandMenu)item).updateCommandText();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof CommandMenuItem) {
            CommandMenuItem cmi = (CommandMenuItem)source;
            AbstractCommand cmd = cmi.getCommand();
            cmd.execute();
        }
    }
}

