/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.util.PaletteListener;
import de.renew.draw.ui.ontology.Tool;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ToolButton
implements ActionListener,
MouseListener,
KeyListener {
    private static final String PROP_PRE = "de.renew.keymap.";
    public static final int POPUP_MENU = 0;
    public static final int DIALOG = 1;
    public static final Logger LOGGER = Logger.getLogger(ToolButton.class);
    private String _name;
    private Tool _tool;
    private JToggleButton _button;
    private PaletteListener _listener;
    private char _keyChar;
    private final ArrayList<Component> _additionalComponents = new ArrayList();
    private int _alternativeMode = 1;

    public ToolButton(PaletteListener listener, String iconName, String name, Tool tool) {
        ImageIcon[] icons = ToolButton.createIconsByGuess(iconName);
        this.createButton(listener, icons[0], icons[1], name, tool);
        this.associateKey(name.replaceAll(" ", "_"));
    }

    public ToolButton(PaletteListener listener, Icon icon, Icon selectedIcon, String name, Tool tool) {
        this.createButton(listener, icon, selectedIcon, name, tool);
        this.associateKey(name.replaceAll(" ", "_"));
    }

    private void associateKey(String modifiedName) {
        String key;
        PluginProperties props;
        DrawPlugin app = DrawPlugin.getCurrent();
        if (app != null && (props = app.getProperties()).getBoolProperty("de.renew.keymap.use-mapping") && (key = props.getProperty(PROP_PRE + modifiedName)) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(ToolButton.class.getName() + ": found key mapping entry: " + key));
            }
            if (key.trim().length() == 1) {
                final ToolButton handle = this;
                Runnable r = new Runnable(){
                    int _count = 0;

                    @Override
                    public void run() {
                        DrawApplication gui = DrawPlugin.getGui();
                        if (gui != null) {
                            JFrame frame = gui.getFrame();
                            if (frame != null) {
                                frame.addKeyListener(handle);
                            } else if (this._count < 10) {
                                ++this._count;
                                EventQueue.invokeLater(this);
                            }
                        } else if (this._count < 10) {
                            ++this._count;
                            EventQueue.invokeLater(this);
                        }
                    }
                };
                EventQueue.invokeLater(r);
                this._keyChar = key.trim().charAt(0);
            }
        }
    }

    private void createButton(PaletteListener listener, Icon icon, Icon selectedIcon, String name, Tool tool) {
        this._button = new JToggleButton();
        LOGGER.debug((Object)"ToolButton overwrites setSelected method in it's model.");
        this._button.setModel(new ToolButtonModel());
        this._button.setIcon(icon);
        this._button.setToolTipText(name);
        this._button.setName(name);
        if (selectedIcon != null) {
            this._button.setPressedIcon(selectedIcon);
        }
        this._button.addMouseListener(this);
        this._tool = tool;
        this._name = name;
        this._listener = listener;
    }

    public Tool tool() {
        return this._tool;
    }

    public void setTool(Tool tool) {
        this._tool = tool;
    }

    public String name() {
        return this._name;
    }

    public String getHotkey() {
        if (Character.isLetterOrDigit(this._keyChar) || this._keyChar == '.') {
            return " (" + this._keyChar + ")";
        }
        return "";
    }

    public void addAdditionalComponent(Component component) {
        this._additionalComponents.add(component);
    }

    public void removeAdditionalComponent(Component component) {
        this._additionalComponents.remove(component);
    }

    public void setAlternativeMode(int mode) {
        this._alternativeMode = mode;
    }

    public Object attributeValue() {
        return this.tool();
    }

    public AbstractButton button() {
        return this._button;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
            if (!this._additionalComponents.isEmpty()) {
                switch (this._alternativeMode) {
                    case 0: {
                        this.showAdditionalComponentsMenu(e);
                        break;
                    }
                    case 1: {
                        this.showAdditionalComponentsDialog();
                    }
                }
            }
        } else {
            boolean doubleClick = e.getClickCount() > 1;
            this._listener.paletteUserSelected(this, doubleClick);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._listener.paletteUserOver(this, true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._listener.paletteUserOver(this, false);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this._listener.paletteUserSelected(this, true);
    }

    private void showAdditionalComponentsMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        boolean isEmpty = true;
        for (Component c : this._additionalComponents) {
            if (!(c instanceof JMenuItem)) continue;
            menu.add(c);
            isEmpty = false;
        }
        if (!isEmpty) {
            Point p = e.getLocationOnScreen();
            Point p2 = this.button().getLocationOnScreen();
            menu.show(this.button(), p.x - p2.x, p.y - p2.y);
        }
    }

    private void showAdditionalComponentsDialog() {
        JTabbedPane tabbedPane = new JTabbedPane();
        for (Component c : this._additionalComponents) {
            tabbedPane.add(c);
        }
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(this.button()));
        dialog.setLocationRelativeTo(this.button());
        dialog.add(tabbedPane);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.validate();
        dialog.setVisible(true);
    }

    private static ImageIcon[] createIconsByGuess(String name) {
        ImageIcon firstGuess;
        ImageIcon[] result = new ImageIcon[2];
        try {
            firstGuess = ToolButton.createIcon(name + ".gif");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Guess for " + name + ".gif failed with " + String.valueOf(e)));
            firstGuess = null;
        }
        if (firstGuess != null) {
            result[0] = firstGuess;
            result[1] = null;
        } else {
            result[0] = ToolButton.createIcon(name + "1.gif");
            result[1] = ToolButton.createIcon(name + "2.gif");
        }
        return result;
    }

    private static ImageIcon createIcon(String name) {
        URL iconURL = PluginManager.getInstance().getBottomClassLoader().getResource(name);
        if (iconURL == null) {
            File icon = new File(name);
            if (!icon.isFile()) {
                return null;
            }
            try {
                iconURL = icon.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return new ImageIcon(iconURL);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!(e.isControlDown() || e.isAltDown() || e.isMetaDown())) {
            if (e.getKeyChar() == this._keyChar) {
                this._listener.paletteUserSelected(this, false);
            } else if (e.getKeyChar() == Character.toUpperCase(this._keyChar)) {
                this._listener.paletteUserSelected(this, true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static class ToolButtonModel
    extends JToggleButton.ToggleButtonModel {
        @Override
        public void setSelected(boolean b) {
        }

        public void setTrulySelected(boolean b) {
            super.setSelected(b);
        }
    }
}

