/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.StandardDrawingViewContainer;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingListener;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StandardDrawingLookup {
    public static final Logger LOGGER = Logger.getLogger(StandardDrawingLookup.class);
    private DrawingView _previousView;
    private DrawingView _currentView;
    private final Map<Drawing, StandardDrawingViewContainer> _openedDrawings = new HashMap<Drawing, StandardDrawingViewContainer>();
    private final Vector<DrawingListener> _drawingListeners = new Vector();

    public DrawingView getPreviousView() {
        return this._previousView;
    }

    public void setCurrentView(DrawingView currentView) {
        LOGGER.debug((Object)("Setting current view to " + currentView.drawing().getName()));
        this._previousView = this._currentView;
        this._currentView = currentView;
    }

    public DrawingView getCurrentView() {
        if (this._currentView != null) {
            return this._currentView;
        }
        return EditorApi.getNullDrawingView();
    }

    public StandardDrawingViewContainer getViewContainerForDrawing(Drawing drawing) {
        try {
            return this._openedDrawings.get(drawing);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Tried to retrieve a view container for a drawing that isn't opened.");
            return null;
        }
    }

    public void addViewContainer(Drawing drawing, StandardDrawingViewContainer container) {
        this._openedDrawings.put(drawing, container);
        this.drawingAdded(drawing);
    }

    public void removeViewContainer(Drawing drawing) {
        this._openedDrawings.remove(drawing);
        this.drawingReleased(drawing);
    }

    public Drawing getLoadedDrawingForFile(File file) {
        for (Map.Entry<Drawing, StandardDrawingViewContainer> entry : this._openedDrawings.entrySet()) {
            File filename = entry.getKey().getFilename();
            if (filename == null || !filename.getAbsoluteFile().equals(file.getAbsoluteFile())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Enumeration<Drawing> getAllDrawings() {
        Vector<Drawing> vector = new Vector<Drawing>(this._openedDrawings.keySet());
        return vector.elements();
    }

    public void closeAllDrawings() {
        LOGGER.debug((Object)"Closing all opened drawings.");
        ArrayList<Drawing> allDrawings = Collections.list(this.getAllDrawings());
        allDrawings.sort((d1, d2) -> d2.getName().compareTo(d1.getName()));
        for (Drawing drawingEntry : allDrawings) {
            StandardDrawingViewContainer container = this._openedDrawings.get(drawingEntry);
            if (container == null) continue;
            Drawing drawing = container.getView().drawing();
            container.setVisible(false);
            if (container.isVisible()) continue;
            this._openedDrawings.remove(drawing);
            this.drawingReleased(drawing);
        }
    }

    public void addDrawingListener(DrawingListener listener) {
        this._drawingListeners.add(listener);
    }

    public void removeDrawingListener(DrawingListener listener) {
        this._drawingListeners.remove(listener);
    }

    private void drawingAdded(Drawing drawing) {
        this._drawingListeners.forEach(listener -> listener.drawingAdded(drawing));
    }

    private void drawingReleased(Drawing drawing) {
        this._drawingListeners.forEach(listener -> listener.drawingReleased(drawing));
        if (this._previousView != null && this._previousView.drawing().equals(drawing)) {
            this._previousView = EditorApi.getNullDrawingView();
        }
        if (this._currentView != null && this._currentView.drawing().equals(drawing)) {
            this._currentView = this._previousView;
            this._previousView = EditorApi.getNullDrawingView();
        }
    }
}

