/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.util.xml.XElement;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeListener;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.io.api.FileApi;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileType;
import de.renew.util.Lock;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StandardDrawing
extends CompositeFigure
implements Drawing,
MultipleCDockableLayout {
    public static final Logger LOGGER = Logger.getLogger(StandardDrawing.class);
    private static FilterContainer _filterContainer;
    static final String UNTITLED = "untitled";
    private static final long serialVersionUID = -2602151437447962046L;
    private final int _drawingSerializedDataVersion = 1;
    private transient Vector<DrawingChangeListener> _listeners;
    private transient Lock _lock;
    private String _drawingName = "untitled";
    private transient File _drawingFileName = null;
    private transient boolean _modified = false;
    private transient boolean _backupStatus = false;
    protected transient int _maxUsedId = 0;
    protected transient Hashtable<Integer, Figure> _usedIds = new Hashtable();

    public StandardDrawing() {
        this._listeners = new Vector(2);
        this._lock = new Lock();
    }

    @Override
    public String getName() {
        return this._drawingName;
    }

    @Override
    public void setName(String name) {
        this._drawingName = name;
    }

    public Dimension getSize() {
        return new Dimension(this.getBounds().width, this.getBounds().height);
    }

    @Override
    public File getFilename() {
        return this._drawingFileName;
    }

    @Override
    public void setFilename(File filename) {
        this._drawingFileName = filename;
    }

    @Override
    public boolean getBackupStatus() {
        return this._backupStatus;
    }

    @Override
    public void setBackupStatus(boolean status) {
        this._backupStatus = status;
    }

    @Override
    public void addDrawingChangeListener(DrawingChangeListener listener) {
        this._listeners.addElement(listener);
    }

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener listener) {
        this._listeners.removeElement(listener);
    }

    @Override
    public Enumeration<DrawingChangeListener> drawingChangeListeners() {
        return this._listeners.elements();
    }

    @Override
    public Figure remove(Figure figure) {
        if (figure instanceof FigureWithID) {
            this.freeID((FigureWithID)figure);
        }
        Figure result = null;
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(StorableApi.createFigureChangeEvent(figure, null));
            result = figure;
        }
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return result;
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
        Figure figure = e.getFigure();
        if (this.fFigures.contains(figure)) {
            this._modified = true;
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
        } else {
            LOGGER.error((Object)"Attempt to remove non-existing figure");
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
        this._modified = true;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                DrawingChangeListener l = this._listeners.elementAt(i);
                l.drawingInvalidated(new DrawingChangeEvent(this, e.getInvalidatedRectangle()));
            }
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                DrawingChangeListener l = this._listeners.elementAt(i);
                l.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    @Override
    public synchronized void checkDamage() {
        StandardDrawing object = this;
        EventQueue.invokeLater(() -> {
            Enumeration<DrawingChangeListener> each = this._listeners.elements();
            while (each.hasMoreElements()) {
                DrawingChangeListener l = each.nextElement();
                l.drawingRequestUpdate(new DrawingChangeEvent(object, null));
            }
        });
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        Rectangle box = null;
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!f.isVisible()) continue;
            Rectangle r = f.displayBox();
            if (box == null) {
                box = r;
                continue;
            }
            box.add(r);
        }
        if (box == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        return new Rectangle(box.x - 10, box.y - 10, box.width + 20, box.height + 20);
    }

    @Override
    public void basicDisplayBox(Point p1, Point p2) {
    }

    @Override
    public void lock() {
        this._lock.lock();
    }

    @Override
    public void unlock() {
        this._lock.unlock();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this._listeners = new Vector(2);
        this._lock = new Lock();
        this._maxUsedId = 0;
        this._usedIds = new Hashtable();
        this.recomputeIDCache();
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void clearModified() {
        this._modified = false;
    }

    @Override
    public Rectangle getBounds() {
        return this.displayBox();
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(430, 406);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._modified = false;
        this.recomputeIDCache();
    }

    @Override
    public String getWindowCategory() {
        return "JHotDrawings";
    }

    public static FilterContainer getFilterContainer() {
        return Objects.requireNonNullElseGet(_filterContainer, () -> new FilterContainer(FileApi.createExtensionFileFilter(FileType.DRAW)));
    }

    @Override
    public ExtensionFileFilter getDefaultFileFilter() {
        return StandardDrawing.getFilterContainer().getDefaultFileFilter();
    }

    @Override
    public HashSet<ExtensionFileFilter> getImportFileFilters() {
        return StandardDrawing.getFilterContainer().getImportFileFilters();
    }

    @Override
    public HashSet<ExtensionFileFilter> getExportFileFilters() {
        return StandardDrawing.getFilterContainer().getExportFileFilters();
    }

    @Override
    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    @Override
    public void init() {
    }

    @Override
    public Drawing add(Drawing drawing) {
        FigureEnumeration figures = drawing.figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            this.add(figure);
        }
        return drawing;
    }

    @Override
    public Drawing add(Drawing drawing, int x, int y) {
        FigureEnumeration figures = drawing.figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            this.add(figure);
            figure.moveBy(x, y);
        }
        return drawing;
    }

    @Override
    public Figure add(Figure figure) {
        if (figure instanceof FigureWithID) {
            if (this._maxUsedId == 0) {
                this.recomputeIDCache();
            }
            this.checkAndAssignID((FigureWithID)figure);
        }
        Figure result = super.add(figure);
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return result;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    public void writeStream(DataOutputStream dataOutputStream) {
    }

    public void readStream(DataInputStream dataInputStream) {
    }

    public void writeXML(XElement xElement) {
    }

    public void readXML(XElement xElement) {
    }

    private void checkAndAssignID(FigureWithID figure) {
        int oldID;
        int newID = oldID = figure.getID();
        FigureWithID inCache = (FigureWithID)this._usedIds.get(oldID);
        if (inCache != null && inCache != figure) {
            newID = 0;
        }
        if (newID == 0) {
            newID = this.newUniqueID();
            figure.setID(newID);
        }
        this._usedIds.put(newID, figure);
    }

    private int newUniqueID() {
        ++this._maxUsedId;
        if (this._usedIds.containsKey(this._maxUsedId)) {
            boolean resetOnce = false;
            while (this._usedIds.containsKey(this._maxUsedId)) {
                ++this._maxUsedId;
                if (this._maxUsedId != Integer.MIN_VALUE) continue;
                this._maxUsedId = 1;
                if (resetOnce) {
                    throw new RuntimeException("Maximum number of figures exceeded.");
                }
                resetOnce = true;
            }
        }
        return this._maxUsedId;
    }

    protected void recomputeIDCache() {
        Vector<Figure> offendingFigures = new Vector<Figure>();
        this._usedIds.clear();
        this.addToIDCache(this, offendingFigures);
        Enumeration<Figure> figureList = offendingFigures.elements();
        while (figureList.hasMoreElements()) {
            this.checkAndAssignID((FigureWithID)figureList.nextElement());
        }
    }

    private void addToIDCache(CompositeFigure container, Vector<Figure> offendingFigures) {
        FigureEnumeration knownFigures = container.figures();
        while (knownFigures.hasMoreElements()) {
            Figure figure = knownFigures.nextFigure();
            if (figure instanceof FigureWithID) {
                int usedID = ((FigureWithID)figure).getID();
                if (usedID == 0) {
                    offendingFigures.addElement(figure);
                    continue;
                }
                FigureWithID inCache = (FigureWithID)this._usedIds.get(usedID);
                if (inCache == null || inCache == figure) {
                    this._usedIds.put(usedID, figure);
                    if (usedID <= this._maxUsedId) continue;
                    this._maxUsedId = usedID;
                    continue;
                }
                offendingFigures.addElement(figure);
                continue;
            }
            if (!(figure instanceof CompositeFigure)) continue;
            this.addToIDCache((CompositeFigure)figure, offendingFigures);
        }
    }

    public void assignID(FigureWithID figure, int id) {
        FigureWithID inCache = (FigureWithID)this._usedIds.get(id);
        if (inCache != null && inCache != figure) {
            throw new IllegalArgumentException("The id is already in use!");
        }
        this._usedIds.remove(figure.getID());
        figure.setID(id);
        this._usedIds.put(id, figure);
    }

    private void freeID(FigureWithID figure) {
        Integer usedID = figure.getID();
        if (this._usedIds.get(usedID) == figure) {
            this._usedIds.remove(usedID);
        }
    }

    public FigureWithID getFigureWithID(int id) {
        return (FigureWithID)this._usedIds.get(id);
    }
}

