/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.PartialSelectableFigure;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ChildDragTracker;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.draw.ui.ontology.Tool;
import de.renew.util.StringUtil;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class SelectionTool
extends AbstractTool {
    public static final Logger LOGGER = Logger.getLogger(SelectionTool.class);
    private Tool _child = null;
    private Tool _lastChild = null;
    private DrawingView _frozenView = null;

    public SelectionTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        if (this._child != null) {
            return;
        }
        try {
            boolean rightClick;
            boolean bl = rightClick = (e.getModifiersEx() & 0x1800) != 0;
            if (this._lastChild != null && e.getClickCount() == 2 && !rightClick) {
                this._child = this._lastChild;
                this._lastChild = null;
            } else {
                if (this._frozenView == null) {
                    this._frozenView = this.view();
                    this._frozenView.freezeView();
                }
                FigureHandle handle = null;
                if (!rightClick && this.view().selectionCount() == 1) {
                    handle = this.view().findHandle(x, y);
                }
                if (handle != null) {
                    this._lastChild = this._child = this.createHandleTracker(this.fEditor, handle);
                } else {
                    this._lastChild = null;
                    Figure figure = this.drawing().findFigure(x, y);
                    if (figure == null && (handle = this.view().findHandle(x, y)) != null) {
                        figure = handle.owner();
                    }
                    boolean selectableFigureFound = false;
                    if (figure != null) {
                        selectableFigureFound = true;
                        if (figure instanceof PartialSelectableFigure) {
                            PartialSelectableFigure partialSelectableFigure = (PartialSelectableFigure)((Object)figure);
                            if (!this.view().selection().contains(figure)) {
                                selectableFigureFound = false;
                                if (partialSelectableFigure.isModifierSelectable() && e.isAltDown()) {
                                    selectableFigureFound = true;
                                } else if (partialSelectableFigure.isSelectableInRegion(x, y)) {
                                    selectableFigureFound = true;
                                }
                            }
                        }
                    }
                    if (selectableFigureFound) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Click-on-figure: " + String.valueOf(figure)));
                        }
                        if (e.isControlDown()) {
                            if (!rightClick) {
                                this.openTargetLocation(figure);
                            }
                        } else {
                            if (e.getClickCount() >= 2 && !rightClick) {
                                figure.inspect(this.view(), false);
                                return;
                            }
                            if (rightClick && this.alternateInspectFigure(figure)) {
                                return;
                            }
                            this._child = this.createDragTracker(this.fEditor, figure);
                        }
                    } else {
                        if (!e.isShiftDown()) {
                            this.view().clearSelection();
                        }
                        this._child = this.createAreaTracker(this.fEditor);
                    }
                }
            }
            if (this._child != null) {
                if (this._child instanceof DragTracker || this._child instanceof SelectAreaTracker) {
                    this._child.mouseDown(e, x, y);
                } else {
                    this._child.mouseDown(e, e.getX(), e.getY());
                }
            }
        }
        catch (Error | RuntimeException ex) {
            if (this._frozenView != null) {
                this._frozenView.unfreezeView();
                this._frozenView = null;
            }
            throw ex;
        }
    }

    private void openTargetLocation(Figure figure) {
        block11: {
            Object target = figure.getAttribute("targetLocation");
            if (target != null) {
                try {
                    URI targetURI = new URI((String)target);
                    try {
                        String scheme = targetURI.getScheme();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(SelectionTool.class.getSimpleName() + ": Trying to open: Scheme | Host | Path = " + scheme + " | " + targetURI.getHost() + " | " + targetURI.getPath()));
                        }
                        if (scheme == null && !DrawPlugin.getGui().canOpen(targetURI)) {
                            scheme = "file";
                            targetURI = new URI(scheme, targetURI.getHost(), targetURI.getPath(), targetURI.getFragment());
                        }
                        if (scheme == null) {
                            URI drawingURI = new File(this.drawing().getFilename().getCanonicalPath()).toURI();
                            URI uri = drawingURI.resolve(targetURI);
                            DrawPlugin.getGui().openOrLoadDrawing(new File(uri.getPath()));
                            break block11;
                        }
                        if ("sim".equals(scheme)) {
                            this.simAccess(targetURI);
                            break block11;
                        }
                        Desktop.getDesktop().browse(targetURI);
                    }
                    catch (URISyntaxException e) {
                        URI drawingURI = new File(this.drawing().getFilename().getCanonicalPath()).toURI();
                        String path = StringUtil.getPath((String)drawingURI.getPath());
                        Desktop.getDesktop().open(new File(path, (String)target));
                    }
                    catch (IOException e2) {
                        LOGGER.error((Object)("Could not find file: " + targetURI.getPath() + " " + e2.getMessage()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(SelectionTool.class.getSimpleName() + ": "), (Throwable)e2);
                        }
                    }
                }
                catch (Exception e3) {
                    LOGGER.error((Object)("An error occurred during file access (malformed URL?): " + e3.getMessage()));
                    if (!LOGGER.isDebugEnabled()) break block11;
                    LOGGER.debug((Object)(SelectionTool.class.getSimpleName() + ": "), (Throwable)e3);
                }
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this._child != null) {
            this._child.mouseDrag(e, x, y);
            this._lastChild = null;
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this._frozenView != null) {
            this._frozenView.unfreezeView();
            this._frozenView = null;
        }
        if (this._child != null) {
            this._child.mouseUp(e, x, y);
        }
        this._child = null;
    }

    protected Tool createHandleTracker(DrawingEditor editor, FigureHandle handle) {
        return new HandleTracker(editor, handle);
    }

    protected Tool createDragTracker(DrawingEditor editor, Figure f) {
        if (f instanceof ChildFigure) {
            return new ChildDragTracker(editor, (ChildFigure)f);
        }
        return new DragTracker(editor, f);
    }

    protected Tool createAreaTracker(DrawingEditor editor) {
        return new SelectAreaTracker(editor);
    }

    protected boolean alternateInspectFigure(Figure f) {
        return f.inspect(this.view(), true);
    }

    @Override
    public void draw(Graphics g) {
        if (this._child != null) {
            this._child.draw(g);
        }
    }

    @Override
    public void deactivate() {
        if (this._frozenView != null) {
            this._frozenView.unfreezeView();
            this._frozenView = null;
        }
        super.deactivate();
    }
}

