/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.AbstractConnector;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Figure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ChopBoxConnector
extends AbstractConnector {
    private static final long serialVersionUID = -1461450322712345462L;

    public ChopBoxConnector() {
    }

    public ChopBoxConnector(Figure owner) {
        super(owner);
    }

    @Override
    public Point findStart(ConnectionFigure connection) {
        Rectangle r1 = connection.pointCount() == 2 ? connection.end().displayBox() : new Rectangle(connection.pointAt(1), new Dimension(0, 0));
        return this.chop(connection.start().owner(), r1);
    }

    @Override
    public Point findEnd(ConnectionFigure connection) {
        Rectangle r1 = connection.pointCount() == 2 ? connection.start().displayBox() : new Rectangle(connection.pointAt(connection.pointCount() - 2), new Dimension(0, 0));
        return this.chop(connection.end().owner(), r1);
    }

    protected Point chop(Figure target, Rectangle source) {
        Rectangle r;
        return Geom.angleToPoint(r, ((r = target.displayBox()).intersection(source).equals(r) ? Math.PI : 0.0) + Geom.pointToAngle(r, Geom.center(source)));
    }
}

