/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import de.renew.ioontology.ExtensionFileFilter;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Objects;

public class SimpleFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
ExtensionFileFilter {
    private String ext;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public SimpleFileFilter(String extension, String description) {
        this.setExtension(extension);
        this.setDescription(description);
    }

    protected SimpleFileFilter() {
    }

    public void allowHidden(boolean b) {
        this.allowHidden = b;
    }

    public void allowDirectory(boolean b) {
        this.allowDirectory = b;
    }

    public boolean isHiddenAllowed() {
        return this.allowHidden;
    }

    public boolean isDirectoryAllowed() {
        return this.allowDirectory;
    }

    @Override
    public boolean accept(File f) {
        if (f != null && (this.allowHidden || !f.isHidden() && !f.getName().startsWith("."))) {
            if (f.isDirectory()) {
                return this.allowDirectory;
            }
            String extension = StringUtil.getExtension((String)f.getName());
            return this.ext.equals(extension);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExtension() {
        return this.ext;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public void setExtension(String string) {
        this.ext = string;
    }

    public boolean equals(Object o) {
        return o instanceof SimpleFileFilter && Objects.equals(((SimpleFileFilter)o).getExtension(), this.getExtension());
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.getExtension());
    }
}

