/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui;

import CH.ifa.draw.gui.ButtonLayoutParser;
import CH.ifa.draw.gui.ParseException;
import CH.ifa.draw.gui.TokenMgrError;
import CH.ifa.draw.gui.ToolButtonContainer;
import java.awt.Component;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

@Deprecated
public class StorableButtonContainerLayout {
    protected final List<List<String>> _layout;
    protected final Set<String> _requiredPalettes;
    protected final String _layoutName;
    private static final Logger LOGGER = Logger.getLogger(StorableButtonContainerLayout.class);

    private StorableButtonContainerLayout(List<List<String>> layout, Set<String> requiredPalettes, String layoutName) {
        this._layout = layout;
        this._requiredPalettes = requiredPalettes;
        this._layoutName = layoutName;
    }

    public String toString() {
        return this._layoutName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StorableButtonContainerLayout)) {
            return false;
        }
        return this._layoutName.equals(((StorableButtonContainerLayout)o)._layoutName);
    }

    public boolean isAvailable(Set<String> availablePalettes) {
        return availablePalettes.containsAll(this._requiredPalettes);
    }

    public static StorableButtonContainerLayout createLayout(Component[] components, Map<String, String> groupLookup, String layoutName) {
        ArrayList<List<String>> layout = new ArrayList<List<String>>();
        HashSet<String> requiredPalettes = new HashSet<String>();
        for (Component component : components) {
            Component[] buttons;
            if (!(component instanceof ToolButtonContainer)) continue;
            ArrayList<String> container = new ArrayList<String>();
            for (Component button : buttons = ((ToolButtonContainer)component).getButtons()) {
                String name = button.getName();
                if (name == null || name.isEmpty()) continue;
                container.add(name);
                String group = groupLookup.get(name);
                if (group == null) continue;
                requiredPalettes.add(group);
            }
            layout.add(container);
        }
        return new StorableButtonContainerLayout(layout, requiredPalettes, layoutName);
    }

    public static List<Set<AbstractButton>> readLayout(StorableButtonContainerLayout layout, Map<String, AbstractButton> buttonLookup) {
        ArrayList<Set<AbstractButton>> result = new ArrayList<Set<AbstractButton>>();
        for (List<String> set : layout._layout) {
            LinkedHashSet<AbstractButton> buttonSet = new LinkedHashSet<AbstractButton>();
            for (String name : set) {
                buttonSet.add(buttonLookup.get(name));
            }
            result.add(buttonSet);
        }
        return result;
    }

    public static List<StorableButtonContainerLayout> createLayoutsFromProperties(Properties properties) {
        ArrayList<StorableButtonContainerLayout> result = new ArrayList<StorableButtonContainerLayout>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            try {
                String name = (String)entry.getKey();
                String data = (String)entry.getValue();
                String[] splitString = data.split("%");
                if (splitString.length > 1) {
                    data = splitString[1];
                    ButtonLayoutParser parser = new ButtonLayoutParser(new StringReader(data));
                    Set<String> requiredPalettes = parser.parseRequiredPalettes();
                    data = splitString[0];
                    parser = new ButtonLayoutParser(new StringReader(data));
                    List<List<String>> layout = parser.parseButtons();
                    result.add(new StorableButtonContainerLayout(layout, requiredPalettes, name));
                    continue;
                }
                result.add(new StorableButtonContainerLayout(new ArrayList<List<String>>(), new HashSet<String>(), name));
            }
            catch (ParseException e) {
                LOGGER.error((Object)("Parsing of data failed" + String.valueOf(e) + "\n"));
            }
            catch (TokenMgrError error) {
                LOGGER.error((Object)("Parsing of token failed" + String.valueOf(error) + "\n"));
            }
        }
        return result;
    }

    public static void writeToProperties(Properties properties, StorableButtonContainerLayout layout) {
        StringBuilder builder = new StringBuilder();
        for (List<String> container : layout._layout) {
            for (String button : container) {
                builder.append(button);
                builder.append(",");
            }
            builder.append(";");
        }
        builder.append("%");
        for (String group : layout._requiredPalettes) {
            builder.append(group);
            builder.append(",");
        }
        properties.put(layout._layoutName, builder.toString());
    }
}

