/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopRoundRectangleConnector;
import CH.ifa.draw.figures.RadiusHandle;
import CH.ifa.draw.standard.BoxHandleKit;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.Vector;

public class RoundRectangleFigure
extends AttributeFigure {
    private static final int DEFAULT_ARC = 8;
    private static final double DEFAULT_RATIO = 0.1;
    public static final String ARC_SCALE_ATTR = "ArcScale";
    private static final long serialVersionUID = 7907900248924036885L;
    private Rectangle _displayBox = null;
    private int _arcWidth = 8;
    private int _arcHeight = 8;
    private transient double _xRatio;
    private transient double _yRatio;
    private final int _roundRectangleSerializedDataVersion = 1;

    public RoundRectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
        this._arcHeight = 8;
        this._arcWidth = 8;
        this._yRatio = 0.1;
        this._xRatio = 0.1;
    }

    public RoundRectangleFigure(Point origin, Point corner) {
        this._xRatio = (double)this._arcWidth / (double)(corner.x - origin.x);
        this._yRatio = (double)this._arcHeight / (double)(corner.y - origin.y);
        this.basicDisplayBox(origin, corner);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.willChange();
        this._displayBox = new Rectangle(origin);
        this._displayBox.add(corner);
        if (this.scaleArc()) {
            this._arcWidth = (int)((double)(corner.x - origin.x) * this._xRatio);
            this._arcHeight = (int)((double)(corner.y - origin.y) * this._yRatio);
        } else {
            this.recalculateRatio();
        }
        this.handlesChanged();
        this.changed();
    }

    private void recalculateRatio() {
        this._xRatio = (double)this.getArcWidth() / (double)this._displayBox.width;
        this._yRatio = (double)this.getArcHeight() / (double)this._displayBox.height;
    }

    private boolean scaleArc() {
        Boolean attr = (Boolean)this.getAttribute(ARC_SCALE_ATTR);
        return Objects.requireNonNullElse(attr, false);
    }

    public void setArc(int width, int height) {
        this.willChange();
        this._arcWidth = width;
        this._arcHeight = height;
        this.recalculateRatio();
        this.changed();
    }

    public int getArcWidth() {
        return Math.min(this._arcWidth, this._displayBox.width);
    }

    public int getArcHeight() {
        return Math.min(this._arcHeight, this._displayBox.height);
    }

    public Point getArc() {
        return new Point(this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        BoxHandleKit.addHandles(this, handles);
        handles.addElement(new RadiusHandle(this));
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this._displayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        RoundRectangle2D.Float s = new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, this.getArcWidth(), this.getArcHeight());
        ((Graphics2D)g).fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        RoundRectangle2D.Float s = new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, this.getArcWidth(), this.getArcHeight());
        ((Graphics2D)g).draw(s);
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(this.getArcWidth() / 2, this.getArcHeight() / 2, this.getArcWidth() / 2, this.getArcHeight() / 2);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopRoundRectangleConnector(this);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._displayBox.x);
        dw.writeInt(this._displayBox.y);
        dw.writeInt(this._displayBox.width);
        dw.writeInt(this._displayBox.height);
        dw.writeInt(this._arcWidth);
        dw.writeInt(this._arcHeight);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._displayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this._arcWidth = dr.readInt();
        this._arcHeight = dr.readInt();
        this.recalculateRatio();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recalculateRatio();
    }
}

