/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopPieConnector;
import CH.ifa.draw.figures.PieAngleHandle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.io.IOException;
import java.util.Vector;

public class PieFigure
extends AttributeFigure {
    static final int START_ANGLE = 1;
    static final int END_ANGLE = 2;
    private Rectangle _displayBox;
    private double _startAngle;
    private double _endAngle;

    public PieFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public PieFigure(Point origin, Point corner) {
        this(origin, corner, 180.0, 90.0);
    }

    public PieFigure(Point origin, Point corner, double startAngle, double endAngle) {
        this.basicDisplayBox(origin, corner);
        this.setStartAngle(startAngle);
        this.setEndAngle(endAngle);
    }

    public double getStartAngle() {
        return this._startAngle;
    }

    public void setStartAngle(double startAngle) {
        this._startAngle = PieFigure.normalizeAngle(startAngle);
        this.changed();
    }

    public void setAngle(int angleKind, double angle) {
        switch (angleKind) {
            case 1: {
                this.setStartAngle(angle);
                break;
            }
            case 2: {
                this.setEndAngle(angle);
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined angle kind: " + angleKind);
            }
        }
    }

    public double getEndAngle() {
        return this._endAngle;
    }

    public void setEndAngle(double endAngle) {
        this._endAngle = PieFigure.normalizeAngle(endAngle);
        this.changed();
    }

    public double getAngle(int angleKind) {
        return switch (angleKind) {
            case 1 -> this._startAngle;
            case 2 -> this._endAngle;
            default -> throw new IllegalArgumentException("Undefined angle kind: " + angleKind);
        };
    }

    static double normalizeAngle(double angle) {
        return (360.0 + angle % 360.0) % 360.0;
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        handles.add(new PieAngleHandle(this, 1));
        handles.add(new PieAngleHandle(this, 2));
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this._displayBox = new Rectangle(origin);
        this._displayBox.add(corner);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            return Geom.ellipseContainsPoint(this.displayBox(), x, y);
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this._displayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        int arcType = 2;
        double angleExtent = this._endAngle - this._startAngle;
        if (angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        Arc2D.Double s = new Arc2D.Double(r.x, r.y, r.width, r.height, this._startAngle, angleExtent, arcType);
        g2.fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        double angleExtent;
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        int arcType = 2;
        if (ColorMap.isTransparent(this.getFillColor())) {
            arcType = 0;
        }
        if ((angleExtent = this._endAngle - this._startAngle) < 0.0) {
            angleExtent += 360.0;
        }
        Arc2D.Double s = new Arc2D.Double(r.x, r.y, r.width, r.height, this._startAngle, angleExtent, arcType);
        g2.draw(s);
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this._displayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopPieConnector(this);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._displayBox.x);
        dw.writeInt(this._displayBox.y);
        dw.writeInt(this._displayBox.width);
        dw.writeInt(this._displayBox.height);
        dw.writeDouble(this._startAngle);
        dw.writeDouble(this._endAngle);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._displayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this._startAngle = dr.readDouble();
        this._endAngle = dr.readDouble();
    }
}

