/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.OutlineFigure;
import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.contrib.TriangleRotationHandle;
import CH.ifa.draw.figures.RectangleFigure;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Vector;

public class TriangleFigure
extends RectangleFigure
implements OutlineFigure {
    static double[] _rotations = new double[]{-1.5707963267948966, -0.7853981633974483, 0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, -2.356194490192345};
    protected int _rotation = 0;

    public TriangleFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public TriangleFigure(Point origin, Point corner) {
        super(origin, corner);
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> h = super.handles();
        h.addElement(new TriangleRotationHandle(this));
        return h;
    }

    public void rotate(double angle) {
        this.willChange();
        double dist = Double.MAX_VALUE;
        int best = 0;
        for (int i = 0; i < _rotations.length; ++i) {
            double d = Math.abs(angle - _rotations[i]);
            if (!(d < dist)) continue;
            dist = d;
            best = i;
        }
        this._rotation = best;
        this.changed();
    }

    public Shape polygon() {
        Rectangle r = this.displayBox();
        GeneralPath p = new GeneralPath();
        switch (this._rotation) {
            case 0: {
                p.moveTo((float)r.x + (float)r.width / 2.0f, r.y);
                p.lineTo(r.x + r.width, r.y + r.height);
                p.lineTo(r.x, r.y + r.height);
                p.closePath();
                break;
            }
            case 1: {
                p.moveTo(r.x + r.width, r.y);
                p.lineTo(r.x + r.width, r.y + r.height);
                p.lineTo(r.x, r.y);
                p.closePath();
                break;
            }
            case 2: {
                p.moveTo(r.x + r.width, (float)r.y + (float)r.height / 2.0f);
                p.lineTo(r.x, r.y + r.height);
                p.lineTo(r.x, r.y);
                p.closePath();
                break;
            }
            case 3: {
                p.moveTo(r.x + r.width, r.y + r.height);
                p.lineTo(r.x, r.y + r.height);
                p.lineTo(r.x + r.width, r.y);
                p.closePath();
                break;
            }
            case 4: {
                p.moveTo((float)r.x + (float)r.width / 2.0f, r.y + r.height);
                p.lineTo(r.x, r.y);
                p.lineTo(r.x + r.width, r.y);
                p.closePath();
                break;
            }
            case 5: {
                p.moveTo(r.x, r.y + r.height);
                p.lineTo(r.x, r.y);
                p.lineTo(r.x + r.width, r.y + r.height);
                p.closePath();
                break;
            }
            case 6: {
                p.moveTo(r.x, (float)r.y + (float)r.height / 2.0f);
                p.lineTo(r.x + r.width, r.y);
                p.lineTo(r.x + r.width, r.y + r.height);
                p.closePath();
                break;
            }
            case 7: {
                p.moveTo(r.x, r.y);
                p.lineTo(r.x + r.width, r.y);
                p.lineTo(r.x, r.y + r.height);
                p.closePath();
            }
        }
        return p;
    }

    @Override
    public Polygon outline() {
        Rectangle r = this.displayBox();
        Polygon p = new Polygon();
        switch (this._rotation) {
            case 0: {
                p.addPoint(r.x + r.width / 2, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y + r.height);
                break;
            }
            case 1: {
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y);
                break;
            }
            case 2: {
                p.addPoint(r.x + r.width, r.y + r.height / 2);
                p.addPoint(r.x, r.y + r.height);
                p.addPoint(r.x, r.y);
                break;
            }
            case 3: {
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y + r.height);
                p.addPoint(r.x + r.width, r.y);
                break;
            }
            case 4: {
                p.addPoint(r.x + r.width / 2, r.y + r.height);
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y);
                break;
            }
            case 5: {
                p.addPoint(r.x, r.y + r.height);
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                break;
            }
            case 6: {
                p.addPoint(r.x, r.y + r.height / 2);
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                break;
            }
            case 7: {
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x, r.y + r.height);
            }
        }
        return p;
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopPolygonConnector(this);
    }

    @Override
    public void drawBackground(Graphics g) {
        g.setColor(this.getFillColor());
        ((Graphics2D)g).fill(this.polygon());
    }

    @Override
    public void drawFrame(Graphics g) {
        g.setColor(this.getFrameColor());
        ((Graphics2D)g).draw(this.polygon());
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this.displayBox();
        return switch (this._rotation) {
            case 0 -> new Insets(r.height, r.width / 2, 0, r.width / 2);
            case 1 -> new Insets(0, r.width, r.height, 0);
            case 2 -> new Insets(r.height / 2, 0, r.height / 2, r.width);
            case 3 -> new Insets(r.height, r.width, 0, 0);
            case 4 -> new Insets(0, r.width / 2, r.height, r.width / 2);
            case 5 -> new Insets(r.height, 0, 0, r.width);
            case 6 -> new Insets(r.height / 2, r.width, r.height / 2, 0);
            case 7 -> new Insets(0, 0, r.height, r.width);
            default -> null;
        };
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.polygon().contains(x, y);
    }

    @Override
    public Point center() {
        return PolygonFigure.center(this.outline());
    }

    public Point chop(Point p) {
        return PolygonFigure.chop(this.outline(), p);
    }

    @Override
    public Object clone() {
        TriangleFigure figure = (TriangleFigure)super.clone();
        figure._rotation = this._rotation;
        return figure;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._rotation);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._rotation = dr.readInt();
    }
}

