/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.PathEntry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringUtil {
    public static final Logger logger = Logger.getLogger(StringUtil.class);
    public static final int separatorLength = File.separator.length();

    public static String replace(String str, String what, String by) {
        int lastIndex;
        StringBuilder rpl = new StringBuilder();
        int whatlen = what.length();
        int index = 0;
        while ((index = str.indexOf(what, lastIndex = index)) >= 0) {
            rpl.append(str, lastIndex, index);
            rpl.append(by);
            index += whatlen;
        }
        rpl.append(str.substring(lastIndex));
        return rpl.toString();
    }

    public static String[] split(String str, String sep) {
        int lastIndex;
        Vector<String> entries = new Vector<String>();
        int seplen = sep.length();
        int index = 0;
        str = (String)str + sep;
        while ((index = ((String)str).indexOf(sep, lastIndex = index)) >= 0) {
            if (index > lastIndex) {
                entries.addElement(((String)str).substring(lastIndex, index));
            }
            index += seplen;
        }
        Object[] result = new String[entries.size()];
        entries.copyInto(result);
        return result;
    }

    public static String firstToUpperCase(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String firstToLowerCase(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static boolean isUpperCaseAt(String str, int n) {
        return n < str.length() && Character.isUpperCase(str.charAt(n));
    }

    public static boolean isLowerCaseAt(String str, int n) {
        return n < str.length() && Character.isLowerCase(str.charAt(n));
    }

    public static int countOccurrences(String str, String sub) {
        int count = 0;
        int index = 0;
        int sublen = sub.length();
        while ((index = str.indexOf(sub, index)) >= 0) {
            index += sublen;
            ++count;
        }
        return count;
    }

    public static int countLines(String str) {
        return StringUtil.countOccurrences(str, "\n") + 1;
    }

    public static String[] splitStringWithEscape(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        char[] sChars = s.toCharArray();
        boolean quoted = false;
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sChars.length; ++i) {
            char currentChar = sChars[i];
            if (currentChar == '\\' && i + 1 < sChars.length && sChars[i + 1] == ' ') {
                escaped = true;
            } else if (currentChar == '\"' || currentChar == '\'') {
                quoted = !quoted;
            } else if (currentChar == '\n' || currentChar == '\r' || currentChar == '\t' || currentChar == ' ') {
                if (quoted) {
                    sb.append(currentChar);
                } else if (escaped) {
                    sb.append(currentChar);
                    escaped = false;
                } else {
                    String token = sb.toString();
                    sb = new StringBuilder();
                    if (!token.matches("^\\s*$")) {
                        tokens.add(token);
                    }
                }
            } else {
                sb.append(currentChar);
            }
            if (i != sChars.length - 1) continue;
            String filename = sb.toString();
            tokens.add(filename);
        }
        String[] tokensArray = new String[tokens.size()];
        return tokens.toArray(tokensArray);
    }

    public static String join(Collection<String> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String join(String[] s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            builder.append(s[i]);
            if (i >= s.length - 1) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String join(String[] s, String delimiter, boolean strict) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (strict) {
                builder.append(StringUtil.trimToEmpty(s[i]));
            } else {
                builder.append(s[i]);
            }
            if (i >= s.length - 1) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    private static int getLastSeparatorPos(String pathname) {
        int pos = pathname.lastIndexOf(47);
        if (pos == -1) {
            pos = pathname.lastIndexOf(File.separator);
        }
        return pos;
    }

    private static int getLastDotPos(String pathname) {
        int lsp = StringUtil.getLastSeparatorPos(pathname);
        int ldp = pathname.lastIndexOf(".");
        if (ldp > lsp) {
            return ldp;
        }
        return pathname.length();
    }

    public static String stripFilenameExtension(String pathname) {
        return pathname.substring(0, StringUtil.getLastDotPos(pathname));
    }

    public static String extendFileNameBy(String filePath, String extension) {
        Object result = StringUtil.stripFilenameExtension(filePath);
        if (!extension.isEmpty()) {
            result = (String)result + "." + extension;
        }
        return result;
    }

    public static String getExtendedFilename(String pathname) {
        return pathname.substring(StringUtil.getLastSeparatorPos(pathname) + 1);
    }

    public static String getFilename(String pathname) {
        return pathname.substring(StringUtil.getLastSeparatorPos(pathname) + 1, StringUtil.getLastDotPos(pathname));
    }

    public static String getExtension(String pathname) {
        int firstAfterDot = StringUtil.getLastDotPos(pathname) + 1;
        if (firstAfterDot < pathname.length()) {
            return pathname.substring(firstAfterDot).toLowerCase();
        }
        return "";
    }

    public static String getPath(String pathname) {
        int lastPos = StringUtil.getLastSeparatorPos(pathname);
        if (lastPos < 0) {
            return "";
        }
        return pathname.substring(0, lastPos);
    }

    public static String makeRelative(String basePathname, String pathname) {
        if (pathname != null) {
            if (basePathname == null) {
                pathname = StringUtil.convertToSlashes((String)pathname);
            } else {
                int size;
                basePathname = (String)basePathname + File.separator;
                int index = 0;
                while (true) {
                    size = index;
                    if ((index = ((String)basePathname).indexOf(File.separator, index) + separatorLength) == -1 + separatorLength || !((String)pathname).startsWith(((String)basePathname).substring(0, index))) break;
                    index += separatorLength;
                }
                StringBuilder dotdots = new StringBuilder();
                if (size > 0) {
                    index = size;
                    while ((index = ((String)basePathname).indexOf(File.separator, index)) >= 0) {
                        index += separatorLength;
                        dotdots.append("../");
                    }
                }
                pathname = String.valueOf(dotdots) + StringUtil.convertToSlashes(((String)pathname).substring(size));
            }
        }
        return pathname;
    }

    public static String makeCanonical(String pathOrFilename) {
        try {
            String pathname = new File(pathOrFilename).getCanonicalPath();
            if (pathname.equals(pathname.toUpperCase())) {
                return StringUtil.getPath(pathname) + File.separator + StringUtil.getExtendedFilename(pathOrFilename);
            }
            return pathname;
        }
        catch (IOException e) {
            return pathOrFilename;
        }
    }

    public static String makeAbsolute(String basePathname, String path) {
        if (basePathname == null || basePathname.isEmpty() || path.startsWith("/") || path.length() > 2 && path.charAt(1) == ':') {
            return StringUtil.convertToSystem(path);
        }
        while (path.startsWith("../")) {
            path = path.substring(3);
            basePathname = StringUtil.getPath(basePathname);
        }
        return basePathname + File.separator + StringUtil.convertToSystem(path);
    }

    public static String convertToSlashes(String path) {
        return StringUtil.replace(path, File.separator, "/");
    }

    public static String convertToSystem(String path) {
        return StringUtil.replace(path, "/", File.separator);
    }

    public static String[] splitPaths(String paths) {
        return StringUtil.split(paths, File.pathSeparator);
    }

    public static String classToFile(String classname) {
        return StringUtil.replace(classname, ".", File.separator) + ".class";
    }

    public static String unspace(String arg) {
        StringBuilder result = new StringBuilder();
        int n = arg.length();
        boolean space = false;
        boolean first = true;
        for (int i = 0; i < n; ++i) {
            char c = arg.charAt(i);
            if (Character.isWhitespace(c)) {
                space = true;
                continue;
            }
            if (space && !first) {
                result.append(' ');
            }
            space = false;
            first = false;
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isNameOrEmpty(String name, boolean dotAllowed) {
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierStart(name.charAt(i++))) {
                return false;
            }
            while (i < name.length() && Character.isJavaIdentifierPart(name.charAt(i))) {
                ++i;
            }
            if (i >= name.length()) continue;
            if (!dotAllowed) {
                return false;
            }
            if (name.charAt(i++) != '.') {
                return false;
            }
            if (i != name.length()) continue;
            return false;
        }
        return true;
    }

    public static URI makeRelative(URI baseURI, URI uri) {
        URI result = baseURI.relativize(uri);
        if (result.isAbsolute() && StringUtil.equalOrBothNull(baseURI.getScheme(), uri.getScheme()) && StringUtil.equalOrBothNull(baseURI.getAuthority(), uri.getAuthority())) {
            URI lastParent = null;
            int backsteps = 0;
            URI parent = StringUtil.getParent(baseURI, false);
            result = parent.relativize(uri);
            while (result.isAbsolute() && !parent.equals(lastParent)) {
                lastParent = parent;
                ++backsteps;
                parent = StringUtil.getParent(lastParent, true);
                result = parent.relativize(uri);
            }
            if (!result.isAbsolute()) {
                StringBuilder newPath = new StringBuilder();
                newPath.append("../".repeat(Math.max(0, backsteps)));
                newPath.append(result.getPath());
                try {
                    result = new URI(result.getScheme(), result.getAuthority(), newPath.toString(), result.getQuery(), result.getFragment());
                }
                catch (URISyntaxException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    result = uri;
                }
            }
        }
        assert (baseURI.resolve(result).equals(uri)) : "StringUtil.makeRelative result does not hold its contract.\n  given uri=" + String.valueOf(uri) + "\n  verified =" + String.valueOf(baseURI.resolve(result)) + "\n  result   =" + String.valueOf(result) + "\n  baseURI  =" + String.valueOf(baseURI);
        return result;
    }

    private static boolean equalOrBothNull(Object one, Object two) {
        return one == null && two == null || one != null && one.equals(two);
    }

    public static URI getParent(URI uri, boolean directoriesToo) {
        String path = uri.getPath();
        String parent = null;
        if (path != null) {
            int lastPos;
            if (directoriesToo && path.endsWith("/") && path.length() > 1) {
                path = path.substring(0, path.length() - 1);
            }
            if ((lastPos = path.lastIndexOf("/")) >= 0) {
                parent = path.substring(0, lastPos + 1);
            }
        }
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), parent, null, null);
        }
        catch (URISyntaxException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("StringUtil: Could not derive parent URI from " + String.valueOf(uri));
        }
    }

    public static boolean isNull(String text) {
        return text == null;
    }

    public static boolean isEmpty(String text) {
        return text != null && text.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String text) {
        return StringUtil.isNull(text) || StringUtil.isEmpty(text);
    }

    public static String trimToNull(String text) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        return text.trim();
    }

    public static String trimToEmpty(String text) {
        if (text.trim().isEmpty()) {
            return "";
        }
        return text.trim();
    }

    public static String getPart(String text, int index, String separator) {
        if (StringUtil.trimToNull(text) == null || index < 0) {
            return null;
        }
        String[] parts = text.split(separator);
        if (parts.length <= index) {
            return null;
        }
        return parts[index];
    }

    public static String camelCase(String subject, String regex, boolean firstToUpper) {
        String[] split = subject.split(regex);
        StringBuilder resultBuilder = new StringBuilder(firstToUpper ? StringUtil.firstToUpperCase(split[0]) : StringUtil.firstToLowerCase(split[0]));
        for (int i = 1; i < split.length; ++i) {
            resultBuilder.append(StringUtil.firstToUpperCase(split[i]));
        }
        return resultBuilder.toString();
    }

    public static String camelCase(String subject, boolean firstToUpper) {
        return StringUtil.camelCase(subject, "-", firstToUpper);
    }

    public static String camelCase(String subject) {
        return StringUtil.camelCase(subject, true);
    }

    public static String spinalCase(String subject) {
        Pattern pattern = Pattern.compile("[A-Z]");
        Matcher m = pattern.matcher(subject);
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (m.find()) {
            int start = m.start();
            if (start <= 0) continue;
            String substring = subject.substring(last, start);
            sb.append(substring.toLowerCase());
            sb.append("-");
            last = start;
        }
        sb.append(subject.substring(last).toLowerCase());
        return sb.toString();
    }

    public static String upperCaseWords(String str) {
        String[] words = str.split(" ");
        String[] newWords = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            newWords[i] = StringUtil.firstToUpperCase(words[i].toLowerCase());
        }
        return StringUtil.join(newWords, " ");
    }

    public static PathEntry[] canonizePaths(String[] paths) {
        if (paths == null) {
            return new PathEntry[0];
        }
        PathEntry[] canonizedEntries = new PathEntry[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            canonizedEntries[i] = paths[i].trim().startsWith("CLASSPATH" + File.separator) ? new PathEntry(paths[i].trim().substring(9 + File.separator.length()), true) : (paths[i].trim().equals("CLASSPATH") ? new PathEntry("", true) : new PathEntry(StringUtil.makeCanonical(paths[i]), false));
        }
        return canonizedEntries;
    }
}

