/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.SchedulerPair;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Scheduler
implements Runnable {
    private static final Logger _logger = Logger.getLogger(Scheduler.class);
    private static Scheduler _instance;
    private Thread _schedulerThread = null;
    private final TreeMap<Long, SchedulerPair> _queues = new TreeMap();

    private Scheduler() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(String.valueOf(this) + ": created instance."));
        }
    }

    public static synchronized Scheduler instance() {
        if (_instance == null) {
            _instance = new Scheduler();
        }
        return _instance;
    }

    private void ensureRunningThread() {
        if (this._schedulerThread == null) {
            this._schedulerThread = new Thread((Runnable)this, "Renew Scheduler");
            this._schedulerThread.start();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(String.valueOf(this) + ": created thread."));
            }
        }
    }

    private SchedulerPair takeEarliest() {
        if (this._queues.isEmpty()) {
            return null;
        }
        Long key = this._queues.firstKey();
        return this._queues.remove(key);
    }

    private SchedulerPair takePairAt(long timeMillis) {
        Long key = timeMillis;
        SchedulerPair result = this._queues.remove(key);
        return result == null ? new SchedulerPair(key) : result;
    }

    private void putPair(SchedulerPair pair) {
        if (!pair.list.isEmpty()) {
            this._queues.put(pair.key, pair);
        }
    }

    public synchronized void executeIn(Runnable runnable, long deltaMillis) {
        this.executeAt(runnable, System.currentTimeMillis() + deltaMillis);
    }

    public synchronized void executeAt(Runnable runnable, long timeMillis) {
        SchedulerPair pair = this.takePairAt(timeMillis);
        pair.list.addFirst(runnable);
        this.putPair(pair);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)(String.valueOf(this) + ": scheduled " + String.valueOf(runnable) + " for " + timeMillis));
        }
        this.ensureRunningThread();
        this.notifyAll();
    }

    public synchronized void cancel(Runnable runnable) {
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)(String.valueOf(this) + ": request to cancel " + String.valueOf(runnable)));
        }
        Iterator<SchedulerPair> allElements = this._queues.values().iterator();
        Vector<Long> toRemove = new Vector<Long>(this._queues.size());
        while (allElements.hasNext()) {
            SchedulerPair pair = allElements.next();
            pair.list.remove(runnable);
            if (!pair.list.isEmpty()) continue;
            toRemove.add(pair.key);
        }
        Enumeration removeElements = toRemove.elements();
        while (removeElements.hasMoreElements()) {
            this._queues.remove(removeElements.nextElement());
        }
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        SchedulerPair pair;
        do {
            long now;
            if ((pair = this.takeEarliest()) == null) continue;
            long timeMillis = pair.key;
            if (timeMillis > (now = System.currentTimeMillis())) {
                this.putPair(pair);
                try {
                    this.wait(timeMillis - now);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            while (!pair.list.isEmpty()) {
                Runnable runnable = pair.list.removeLast();
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)(String.valueOf(this) + ": executing at " + now + ": " + String.valueOf(runnable)));
                }
                runnable.run();
            }
        } while (pair != null);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(String.valueOf(this) + ": quitting thread."));
        }
        this._schedulerThread = null;
    }
}

