/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rgbase.gui;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.StandardDrawing;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.gui.AnnealingGraphLayout;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.InscribedEdge;
import de.renew.rgbase.elements.Node;
import de.renew.rgbase.gui.Aborter;
import de.renew.rgbase.gui.EdgeInscription;
import de.renew.rgbase.gui.ExploredNodeFigure;
import de.renew.rgbase.gui.UnexploredNodeFigure;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GraphDrawing
extends StandardDrawing
implements LayoutableDrawing {
    public static final int INSC_NOTHING = 0;
    public static final int INSC_ROOT = 1;
    public static final int INSC_ALL = 2;
    public static final int INSC_DEPTH = 3;
    public static final String[] INSC_MODES = new String[]{"Nothing", "State of Root Net Instance", "State of all Net Instances", "Depth"};
    private static final long serialVersionUID = 0L;
    private static final int CONNECTION_LENGTH = 90;
    public static Logger _logger = Logger.getLogger(GraphDrawing.class);
    private boolean _displayEdgeInscriptions = true;
    private final Color _regularNodeColor = Color.WHITE;
    private final Color _startNodeColor = Color.ORANGE;

    public GraphDrawing() {
    }

    public GraphDrawing(Aborter aborter, Collection<Node> nodes, Node startNode, int inscMode, boolean displayEdgeInscriptions) {
        this._displayEdgeInscriptions = displayEdgeInscriptions;
        HashMap<Node, AttributeFigure> nodeFigures = new HashMap<Node, AttributeFigure>();
        for (Node node : nodes) {
            if (aborter.abort()) {
                return;
            }
            this.addExploredFigure(node, nodeFigures, inscMode);
            ((AttributeFigure)nodeFigures.get(node)).setFillColor(this._regularNodeColor);
        }
        ((AttributeFigure)nodeFigures.get(startNode)).setFillColor(this._startNodeColor);
        LinkedList<LineConnection> loops = new LinkedList<LineConnection>();
        for (Node node : nodes) {
            if (aborter.abort()) {
                return;
            }
            this.addEdges(node, nodeFigures, loops);
        }
        new AnnealingGraphLayout().annealingLayout((LayoutableDrawing)this);
        this.drawLoops(loops);
    }

    protected void drawLoops(LinkedList<LineConnection> loops) {
        for (LineConnection connection : loops) {
            Point startPoint = connection.startPoint();
            int x = startPoint.x;
            int y = startPoint.y;
            connection.insertPointAt(new Point(x - 10, y + 25), 1);
            connection.insertPointAt(new Point(x - 20, y + 10), 2);
            connection.updateConnection();
        }
    }

    protected ExploredNodeFigure addExploredFigure(Node node, Map<Node, AttributeFigure> nodeFigures, int inscMode) {
        ExploredNodeFigure nodeFig = new ExploredNodeFigure(node);
        nodeFigures.put(node, (AttributeFigure)nodeFig);
        this.add((Figure)nodeFig);
        this.processNode(node, (AttributeFigure)nodeFig);
        if (inscMode != 0) {
            TextFigure fig = nodeFig.createTextFigure(inscMode);
            this.add((Figure)fig);
            Rectangle d = fig.displayBox();
            int width = d.width;
            int height = d.height;
            nodeFig.displayBox(new Point(0, 0), new Point(width + 20, height + 20));
        }
        return nodeFig;
    }

    protected AttributeFigure addUnexploredFigure() {
        UnexploredNodeFigure nodeFig = new UnexploredNodeFigure();
        this.add((Figure)nodeFig);
        return nodeFig;
    }

    protected void addEdges(Node node, Map<Node, AttributeFigure> nodeFigures, List<LineConnection> loops) {
        Collection<Edge> edges = node.getEdges();
        for (Edge edge : edges) {
            Node targetNode = edge.getTargetNode();
            AttributeFigure nextFig = targetNode == null ? this.addUnexploredFigure() : nodeFigures.get(targetNode);
            if (nodeFigures.get(node) == nextFig) {
                this.connectLoop(nextFig, edge, loops);
                continue;
            }
            this.connect(nodeFigures.get(node), nextFig, edge);
        }
    }

    protected void connect(AttributeFigure start, AttributeFigure end, Edge edge) {
        LineConnection connection = new LineConnection(null, (LineDecoration)new ArrowTip(), "");
        connection.startPoint(0, 0);
        connection.endPoint(0, 0);
        connection.connectStart(start.connectorAt(start.center()));
        connection.connectEnd(end.connectorAt(end.center()));
        connection.updateConnection();
        this.add((Figure)connection);
        this.processConnection(edge, connection);
        if (this._displayEdgeInscriptions && edge instanceof InscribedEdge) {
            EdgeInscription edgeInscription = new EdgeInscription((InscribedEdge)edge, (ParentFigure)connection);
            this.add((Figure)edgeInscription);
        }
    }

    protected void connectLoop(AttributeFigure node, Edge edge, List<LineConnection> loops) {
        LineConnection connection = new LineConnection(null, (LineDecoration)new ArrowTip(), "");
        connection.startPoint(0, 0);
        connection.endPoint(0, 0);
        Connector connector = node.connectorAt(node.center());
        connection.connectStart(connector);
        connection.connectEnd(connector);
        connection.updateConnection();
        this.add((Figure)connection);
        this.processConnection(edge, connection);
        loops.add(connection);
        if (this._displayEdgeInscriptions && edge instanceof InscribedEdge) {
            EdgeInscription edgeInscription = new EdgeInscription((InscribedEdge)edge, (ParentFigure)connection);
            this.add((Figure)edgeInscription);
        }
    }

    protected void processConnection(Edge edge, LineConnection connection) {
    }

    protected void processNode(Node node, AttributeFigure nodeFig) {
    }

    public synchronized void fillInGraph(GraphLayout layout) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (f instanceof ExploredNodeFigure || f instanceof UnexploredNodeFigure) {
                layout.addNode(f);
                continue;
            }
            if (!(f instanceof ConnectionFigure)) continue;
            layout.addEdge((ConnectionFigure)f, 90);
        }
    }

    public void read(StorableInput dr) throws IOException {
        int size = dr.readInt();
        this.fFigures = new Vector(size);
        for (int i = 0; i < size; ++i) {
            try {
                ParentFigure parent;
                Figure f = (Figure)dr.readStorable();
                if (f instanceof EdgeInscription && !this.fFigures.contains(parent = ((EdgeInscription)f).parent())) {
                    this.add((Figure)parent);
                    ++i;
                }
                this.add(f);
                continue;
            }
            catch (IOException e) {
                String desc = GraphDrawing.class.getSimpleName() + ": could not read in " + Figure.class.getSimpleName() + " object:";
                if (_logger.isDebugEnabled()) {
                    _logger.error((Object)desc, (Throwable)e);
                    break;
                }
                _logger.error((Object)(desc + " " + String.valueOf(e)));
                break;
            }
        }
    }
}

