/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rgbase.gui;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.GuiPlugin;
import de.renew.gui.MultipleTokenFigure;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.remote.MarkingAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessor;
import de.renew.rgbase.elements.Node;
import de.renew.rgbase.gui.Inscription;
import de.renew.util.Base64Coder;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ExploredNodeFigure
extends RoundRectangleFigure {
    private static final Logger LOGGER = Logger.getLogger(ExploredNodeFigure.class);
    private static final int LINE_CAP = 4;
    Node _node;

    public ExploredNodeFigure() {
    }

    public ExploredNodeFigure(Node node) {
        super(new Point(0, 0), new Point(20, 20));
        this.setArc(20, 20);
        this._node = node;
    }

    private static void describePlaceInstance(StringBuffer output, PlaceInstance placeInstance) {
        output.append('{');
        try {
            MarkingAccessorImpl marking = new MarkingAccessorImpl(placeInstance, null);
            int distinctTokenCount = marking.getDistinctTokenCount();
            for (int i = 0; i < distinctTokenCount; ++i) {
                ObjectAccessor token = marking.getToken(i);
                int mult = marking.getTokenFreeCount(i);
                boolean isTested = marking.getTokenTested(i);
                output.append(MultipleTokenFigure.getMultString((int)mult, (boolean)isTested));
                output.append(token == null ? "null" : token.asString());
                if (i >= distinctTokenCount - 1) continue;
                output.append(", ");
            }
            output.append('}');
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void describeNetInstance(StringBuffer descBuffer, NetInstance inst) {
        ArrayList places = new ArrayList(inst.getNet().places());
        Collections.sort(places, new Comparator<Place>(){

            @Override
            public int compare(Place p1, Place p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        Iterator iter = places.iterator();
        int placesInLine = 0;
        while (iter.hasNext()) {
            if (placesInLine > 4) {
                descBuffer.append('\n');
                placesInLine = 0;
            } else {
                ++placesInLine;
            }
            Place place = (Place)iter.next();
            descBuffer.append(place.getName());
            descBuffer.append('=');
            ExploredNodeFigure.describePlaceInstance(descBuffer, inst.getInstance(place));
            if (!iter.hasNext()) continue;
            descBuffer.append(", ");
        }
    }

    private static String describeNode(StringBuffer nodeDescBuffer, Node node) {
        NetInstance root = node.getRootNetInstance();
        ArrayList<? extends NetInstance> others = new ArrayList<NetInstance>(node.getNetInstances());
        Collections.sort(others, new Comparator<NetInstance>(){

            @Override
            public int compare(NetInstance i1, NetInstance i2) {
                return i1.getID().compareTo(i2.getID());
            }
        });
        StringBuffer rootDescBuffer = new StringBuffer();
        ExploredNodeFigure.describeNetInstance(rootDescBuffer, root);
        nodeDescBuffer.append(root);
        nodeDescBuffer.append(": \n");
        nodeDescBuffer.append(rootDescBuffer);
        for (NetInstance netInstance : others) {
            if (netInstance == root) continue;
            nodeDescBuffer.append('\n');
            nodeDescBuffer.append(netInstance);
            nodeDescBuffer.append(": \n");
            ExploredNodeFigure.describeNetInstance(nodeDescBuffer, netInstance);
        }
        return rootDescBuffer.toString();
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (this._node != null) {
            NetInstance instance = this._node.getRootNetInstance();
            try {
                GuiPlugin.getCurrent().openInstanceDrawing((NetInstanceAccessor)new NetInstanceAccessorImpl(instance, null));
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Net state seems to have been lost.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StorableOutput dw) {
        super.write(dw);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOException serializeE = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this._node);
        }
        catch (IOException e) {
            serializeE = e;
        }
        if (serializeE == null) {
            dw.writeString(Base64Coder.encode((byte[])baos.toByteArray()));
        } else {
            LOGGER.warn((Object)(ExploredNodeFigure.class.getSimpleName() + ": could not serialize internal net state: "), (Throwable)serializeE);
            dw.writeString("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        String nodeStr = dr.readString();
        if (nodeStr == "") {
            LOGGER.warn((Object)(ExploredNodeFigure.class.getSimpleName() + ": serialized internal net state is missing."));
        } else {
            byte[] data = Base64Coder.decode((String)nodeStr);
            try (ObjectInputStreamUsingBottomLoader ois = new ObjectInputStreamUsingBottomLoader((InputStream)new ByteArrayInputStream(data));){
                this._node = (Node)ois.readObject();
            }
        }
    }

    private TextFigure createTextFigure(String text) {
        TextFigure fig = new TextFigure(text);
        fig.setReadOnly(true);
        fig.setParent((ParentFigure)this);
        this.addToContainer((FigureChangeListener)fig);
        return fig;
    }

    public TextFigure createTextFigure(int inscMode) {
        TextFigure textFigure;
        if (inscMode == 3) {
            textFigure = this.createTextFigure(String.valueOf(this._node.getDepth()));
        } else {
            StringBuffer nodeDescBuffer = new StringBuffer();
            String rootDesc = ExploredNodeFigure.describeNode(nodeDescBuffer, this._node);
            textFigure = new Inscription(rootDesc, nodeDescBuffer.toString(), inscMode == 2, (ParentFigure)this);
        }
        textFigure.setFillColor(new Color(0, 0, 0, 0));
        return textFigure;
    }
}

