/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.remote.RemoteObjectHelperObserver;
import de.renew.remote.RemoteServerRegistry;
import de.renew.remote.RemoteServerRegistryListener;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RemoteObjectHelper
implements RemoteServerRegistryListener {
    public static final Logger LOGGER = Logger.getLogger(RemoteObjectHelper.class);
    private String _service;
    private Map<String, Remote> _remoteObjects;
    private Map<String, Object> _localObjects;
    private int _localCounter = 0;
    private Set<RemoteObjectHelperObserver> _observers;

    public RemoteObjectHelper(String service) {
        this._service = service;
        this._remoteObjects = new HashMap<String, Remote>();
        this._observers = new HashSet<RemoteObjectHelperObserver>();
        this._localObjects = new HashMap<String, Object>();
        RemoteServerRegistry registry = RemoteServerRegistry.instance();
        registry.addRegistryListener(this);
        registry.catchUpOnPreviousConnects(this);
    }

    @Override
    public void connectedTo(RemoteServerRegistry.ServerDescriptor desc) {
        Remote object = null;
        String url = desc.getUrl(this._service);
        try {
            object = Naming.lookup(url);
            this._remoteObjects.put(url, object);
            LOGGER.info((Object)("Found service " + this._service + " on " + url));
            this.fireNotifyObjectAdded(url, object);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)("Could not lookup service " + this._service + " on " + url + ".\nException:\n" + e.getMessage()), (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("Could not lookup service " + this._service + " on " + url + ".\nException:\n" + e.getMessage()), (Throwable)e);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    @Override
    public void disconnectedFrom(RemoteServerRegistry.ServerDescriptor desc) {
        String url = desc.getUrl(this._service);
        if (this._remoteObjects.remove(url) != null) {
            this.fireNotifyObjectRemoved(url);
        }
    }

    public String addLocalObject(Object object) {
        String identifier = "local" + this._localCounter++;
        this._localObjects.put(identifier, object);
        this.fireNotifyObjectAdded(identifier, object);
        return identifier;
    }

    public void removeLocalObjectByIdentifier(String identifier) {
        this._localObjects.remove(identifier);
        this.fireNotifyObjectRemoved(identifier);
    }

    public void removeLocalObject(Object object) {
        LinkedList<String> keysToRemove = new LinkedList<String>();
        for (String key : this._localObjects.keySet()) {
            Object element = this._localObjects.get(key);
            if ((object != null || element != null) && (object == null || !object.equals(element))) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.fireNotifyObjectRemoved(key);
            this._localObjects.remove(key);
        }
    }

    public Map<String, Object> getObjects() {
        Map<String, Object> allObjects = this.getRemoteObjects();
        allObjects.putAll(this.getLocalObjects());
        return allObjects;
    }

    public Map<String, Object> getRemoteObjects() {
        HashMap<String, Object> currentRemoteObjects = new HashMap<String, Object>(this._remoteObjects);
        return currentRemoteObjects;
    }

    public Map<String, Object> getLocalObjects() {
        HashMap<String, Object> currentLocalObjects = new HashMap<String, Object>(this._localObjects);
        return currentLocalObjects;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        RemoteServerRegistry.instance().removeRegistryListener(this);
    }

    public void addObserver(RemoteObjectHelperObserver observer) {
        this._observers.add(observer);
    }

    public void removeObserver(RemoteObjectHelperObserver observer) {
        this._observers.remove(observer);
    }

    protected void fireNotifyObjectAdded(String identifier, Object object) {
        for (RemoteObjectHelperObserver observer : this._observers) {
            observer.notifyObjectAdded(identifier, object);
        }
    }

    protected void fireNotifyObjectRemoved(String identifier) {
        for (RemoteObjectHelperObserver observer : this._observers) {
            observer.notifyObjectRemoved(identifier);
        }
    }
}

