/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetElementID;
import de.renew.net.PlaceInstance;
import de.renew.net.event.PlaceEvent;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.TokenEvent;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.MarkingAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.PlaceAccessor;
import de.renew.remote.PlaceAccessorImpl;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import de.renew.remote.TokenCountsAccessorImpl;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class PlaceInstanceAccessorImpl
extends ObjectAccessorImpl
implements PlaceEventListener,
PlaceInstanceAccessor {
    public static final Logger LOGGER = Logger.getLogger(PlaceInstanceAccessorImpl.class);
    private Set<RemoteEventListener> _listeners = Collections.synchronizedSet(new HashSet());

    public PlaceInstanceAccessorImpl(PlaceInstance place, SimulationEnvironment env) throws RemoteException {
        super(place, env);
    }

    @Override
    public NetElementID getID() throws RemoteException {
        return ((PlaceInstance)this._object).getPlace().getID();
    }

    @Override
    public PlaceAccessor getPlace() throws RemoteException {
        return new PlaceAccessorImpl(((PlaceInstance)this._object).getPlace(), this.getEnvironment());
    }

    public PlaceInstance getPlaceInstance() {
        return (PlaceInstance)this._object;
    }

    @Override
    public NetInstanceAccessor getNetInstance() throws RemoteException {
        return new NetInstanceAccessorImpl(((PlaceInstance)this._object).getNetInstance(), this.getEnvironment());
    }

    @Override
    public MarkingAccessor getMarking() throws RemoteException {
        return new MarkingAccessorImpl((PlaceInstance)this._object, this.getEnvironment());
    }

    @Override
    public TokenCountsAccessor getTokenCounts() throws RemoteException {
        return new TokenCountsAccessorImpl((PlaceInstance)this._object);
    }

    @Override
    public void addSerializableToken(Serializable token) throws RemoteException {
    }

    @Override
    public void addRemoteEventListener(final RemoteEventListener listener) throws RemoteException {
        final PlaceInstanceAccessorImpl impl = this;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set<RemoteEventListener> set = PlaceInstanceAccessorImpl.this._listeners;
                synchronized (set) {
                    if (PlaceInstanceAccessorImpl.this._listeners.isEmpty()) {
                        ((PlaceInstance)PlaceInstanceAccessorImpl.this._object).addPlaceEventListener((PlaceEventListener)impl);
                    }
                    PlaceInstanceAccessorImpl.this._listeners.add(listener);
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    @Override
    public void removeRemoteEventListener(final RemoteEventListener listener) throws RemoteException {
        final PlaceInstanceAccessorImpl impl = this;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set<RemoteEventListener> set = PlaceInstanceAccessorImpl.this._listeners;
                synchronized (set) {
                    PlaceInstanceAccessorImpl.this._listeners.remove(listener);
                    if (PlaceInstanceAccessorImpl.this._listeners.isEmpty()) {
                        ((PlaceInstance)PlaceInstanceAccessorImpl.this._object).removePlaceEventListener((PlaceEventListener)impl);
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    public boolean wantSynchronousNotification() {
        return false;
    }

    public void markingChanged(PlaceEvent event) {
        this.fireRemoteEvent();
    }

    public void tokenAdded(TokenEvent event) {
        this.fireRemoteEvent();
    }

    public void tokenRemoved(TokenEvent event) {
        this.fireRemoteEvent();
    }

    public void tokenTested(TokenEvent event) {
        this.fireRemoteEvent();
    }

    public void tokenUntested(TokenEvent event) {
        this.fireRemoteEvent();
    }

    private void fireRemoteEvent() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set<RemoteEventListener> set = PlaceInstanceAccessorImpl.this._listeners;
                synchronized (set) {
                    for (RemoteEventListener listener : PlaceInstanceAccessorImpl.this._listeners) {
                        try {
                            listener.update();
                        }
                        catch (RemoteException e) {
                            LOGGER.error((Object)("PlaceInstanceAccessor: Remote event to " + String.valueOf(listener) + " probably got lost due to " + String.valueOf(e)));
                        }
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }
}

