/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.remote.AggregateAccessor;
import de.renew.remote.AggregateAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.SocketFactoryDeterminer;
import de.renew.remote.TextTokenAccessor;
import de.renew.remote.TextTokenAccessorImpl;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.unify.Aggregate;
import de.renew.util.TextToken;
import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ObjectAccessorImpl
extends UnicastRemoteObject
implements ObjectAccessor {
    public static final Logger LOGGER = Logger.getLogger(ObjectAccessorImpl.class);
    protected final Object _object;
    protected final SimulationEnvironment _environment;

    protected ObjectAccessorImpl(Object object, SimulationEnvironment environment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        assert (object != null) : "ObjectAccessor instance for null reference is not allowed.";
        this._object = object;
        this._environment = environment;
    }

    public static ObjectAccessor createObjectAccessor(Object object, SimulationEnvironment environment) throws RemoteException {
        if (object == null) {
            return null;
        }
        return new ObjectAccessorImpl(object, environment);
    }

    public Object getObject() {
        return this._object;
    }

    @Override
    public NetInstanceAccessor asNetInstance() throws RemoteException, ClassCastException {
        return new NetInstanceAccessorImpl((NetInstance)this._object, this._environment);
    }

    @Override
    public AggregateAccessor asAggregate() throws RemoteException, ClassCastException {
        return new AggregateAccessorImpl((Aggregate)this._object, this._environment);
    }

    @Override
    public TextTokenAccessor asTextToken() throws RemoteException, ClassCastException {
        return new TextTokenAccessorImpl((TextToken)this._object, this._environment);
    }

    @Override
    public String asString() throws RemoteException {
        return this._object.toString();
    }

    @Override
    public int getFieldCount() throws RemoteException {
        return this._object.getClass().getFields().length;
    }

    @Override
    public String[] getFieldNames() throws RemoteException {
        Field[] fields = this._object.getClass().getFields();
        String[] names = new String[fields.length];
        for (int fieldNr = 0; fieldNr < fields.length; ++fieldNr) {
            names[fieldNr] = fields[fieldNr].getName();
        }
        return names;
    }

    @Override
    public String[] getFieldValues() throws RemoteException, IllegalAccessException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                Field[] fields = ObjectAccessorImpl.this._object.getClass().getFields();
                String[] values = new String[fields.length];
                for (int fieldNr = 0; fieldNr < fields.length; ++fieldNr) {
                    values[fieldNr] = fields[fieldNr].get(ObjectAccessorImpl.this._object).toString();
                }
                return values;
            }
        });
        try {
            return (String[])future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public ObjectAccessor getField(int i) throws RemoteException, IllegalAccessException {
        return ObjectAccessorImpl.createObjectAccessor(this._object.getClass().getFields()[i].get(this._object), this._environment);
    }

    @Override
    public boolean isInstanceOf(Class<?> testClass) throws RemoteException {
        return testClass.isInstance(this._object);
    }

    public void writeTo(ObjectOutput out) throws IOException {
        out.writeObject(this._object);
    }

    protected SimulationEnvironment getEnvironment() {
        return this._environment;
    }
}

