/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.unify.Impossible;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class DynamicFieldFunction
implements Function {
    private final String _field;

    public DynamicFieldFunction(String field) {
        this._field = field;
    }

    public Object function(Object param) throws Impossible {
        try {
            if (param.getClass().isArray()) {
                if ("length".equals(this._field)) {
                    return new Value((Object)Array.getLength(param));
                }
                throw new Impossible();
            }
            Field theField = param.getClass().getField(this._field);
            return Value.possiblyWrap((Object)theField.get(param), (boolean)theField.getType().isPrimitive());
        }
        catch (Exception e) {
            throw new Impossible("Exception occurred during dynamic field access (" + this._field + " on object " + String.valueOf(param) + "): " + String.valueOf(e), (Throwable)e);
        }
    }

    public String toString() {
        return "DynFieldFunc(" + this._field + ")";
    }
}

