/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public abstract class AbstractMethodFunction
implements Function {
    private static final Logger LOGGER = Logger.getLogger(AbstractMethodFunction.class);

    public abstract Object doFunction(Object var1, Object[] var2) throws Exception;

    public Object function(Object param) throws Impossible {
        Tuple tuple = (Tuple)param;
        if (tuple.getArity() != 2) {
            throw new Impossible();
        }
        Object obj = tuple.getComponent(0);
        Tuple args = (Tuple)tuple.getComponent(1);
        Object[] paramArr = new Object[args.getArity()];
        for (int i = 0; i < paramArr.length; ++i) {
            paramArr[i] = args.getComponent(i);
        }
        try {
            return this.doFunction(obj, paramArr);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                String baseError = "Method call resulted in an exception: " + String.valueOf(targetException);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(baseError + " while executing " + String.valueOf(this) + " on object " + String.valueOf(obj) + " with parameters " + this.makeParamList(paramArr)), targetException);
                }
                throw new Impossible(baseError, targetException);
            }
            String baseError = "Exception occurred during method call: " + String.valueOf(e);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(baseError + " while executing " + String.valueOf(this) + " on object " + String.valueOf(obj) + " with parameters " + this.makeParamList(paramArr)), (Throwable)e);
            }
            throw new Impossible(baseError, (Throwable)e);
        }
        catch (LinkageError e) {
            String baseError = "LinkageError occurred during method call: " + String.valueOf(e);
            LOGGER.warn((Object)(baseError + " while executing " + String.valueOf(this)), (Throwable)e);
            throw new Impossible(baseError, (Throwable)e);
        }
    }

    private String makeParamList(Object[] paramArr) {
        if (paramArr == null) {
            return "<null>";
        }
        StringBuilder result = new StringBuilder();
        result.append("<");
        result.append(paramArr.length);
        result.append(">(");
        for (int i = 0; i < paramArr.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(paramArr[0]);
        }
        result.append(")");
        return result.toString();
    }
}

