/*
 * Decompiled with CFR 0.152.
 */
package de.renew.propertymanagement.prop;

import de.renew.plugin.PluginManager;
import de.renew.propertymanagement.prop.ConfigurableProperty;
import de.renew.propertymanagement.prop.IConfigurablePropertyPersister;
import de.renew.propertymanagement.prop.PropertyLoadFailedException;
import de.renew.propertymanagement.prop.PropertySaveFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;

class ConfigurablePropertyPersister
implements IConfigurablePropertyPersister {
    private static final Logger LOGGER = Logger.getLogger(ConfigurablePropertyPersister.class);
    private static final String USER_HOME_PATH = System.getProperty("user.home") + File.separator + ".renew.properties";
    private static final String CONFIG_PATH = PluginManager.getLoaderLocation().getPath() + File.separator + "config" + File.separator + "renew.properties";

    ConfigurablePropertyPersister() {
    }

    @Override
    public void saveProperties(boolean useHomeDir, Map<String, ConfigurableProperty> propertyMap) throws PropertySaveFailedException {
        File file;
        try {
            file = this.getOrCreateFile(useHomeDir ? USER_HOME_PATH : CONFIG_PATH);
        }
        catch (IOException e) {
            String errorMessage = "An Error occurred while creating the properties file: " + (useHomeDir ? USER_HOME_PATH : CONFIG_PATH);
            LOGGER.error((Object)errorMessage);
            throw new PropertySaveFailedException(errorMessage);
        }
        HashMap<String, ConfigurableProperty> propertiesFromFile = new HashMap<String, ConfigurableProperty>();
        Optional<Properties> properties = this.getPropertiesFromFile(file);
        properties.ifPresent(properties1 -> properties1.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> propertiesFromFile.put((String)key, new ConfigurableProperty((String)key, (String)value)))));
        Properties allProps = this.mergeProperties(propertyMap, propertiesFromFile);
        this.writePropertiesToFile(allProps, file);
    }

    @Override
    public void loadProperties(boolean useHomeDir, Map<String, ConfigurableProperty> propertyMap) throws PropertyLoadFailedException {
        File file = new File(useHomeDir ? USER_HOME_PATH : CONFIG_PATH);
        Optional<Properties> propertiesFromFile = this.getPropertiesFromFile(file);
        if (propertiesFromFile.isEmpty()) {
            String errorMessage = "An Error occurred while reading the properties from: " + file.getAbsolutePath();
            LOGGER.error((Object)errorMessage);
            throw new PropertyLoadFailedException(errorMessage);
        }
        for (Map.Entry<String, ConfigurableProperty> property : propertyMap.entrySet()) {
            String value = propertiesFromFile.get().getProperty(property.getKey());
            if (value == null) continue;
            property.getValue().setCurrentValue(value);
        }
    }

    private Properties mergeProperties(Map<String, ConfigurableProperty> propertyMap, Map<String, ConfigurableProperty> propertiesFromFile) {
        Properties allProps = new Properties();
        for (Map.Entry<String, ConfigurableProperty> property : propertiesFromFile.entrySet()) {
            if (propertyMap.containsKey(property.getKey())) continue;
            allProps.setProperty(property.getKey(), property.getValue().getCurrentValue());
        }
        for (Map.Entry<String, ConfigurableProperty> property : propertyMap.entrySet()) {
            if (property.getValue().getCurrentValue() != null) {
                allProps.setProperty(property.getKey(), property.getValue().getCurrentValue());
                continue;
            }
            allProps.setProperty(property.getKey(), property.getValue().getDefaultValue());
        }
        return allProps;
    }

    private void writePropertiesToFile(Properties allProps, File file) throws PropertySaveFailedException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            allProps.store(outputStream, null);
        }
        catch (IOException e) {
            String errorMessage = "Could not save properties to file: " + file.getAbsolutePath();
            LOGGER.error((Object)errorMessage);
            throw new PropertySaveFailedException(errorMessage);
        }
    }

    private File getOrCreateFile(String path) throws IOException {
        File file = new File(path);
        if (file.createNewFile()) {
            LOGGER.warn((Object)("Creating new file: " + path));
        }
        return file;
    }

    private Optional<Properties> getPropertiesFromFile(File file) {
        Properties allProps = new Properties();
        if (file != null && file.exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                allProps.load(inputStream);
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.of(allProps);
    }
}

