/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.util;

import CH.ifa.draw.figures.TextFigure;
import de.renew.momocgui.GUIConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public final class NetUtils {
    private static final Logger log = Logger.getLogger(NetUtils.class);

    public static boolean isMomocField(TextFigure figure) {
        return figure.getText().split("\\r?\\n")[0].equalsIgnoreCase("momoc");
    }

    public static TextFigure writeFormulas(TextFigure figure, Collection<String> formulas) {
        if (!figure.getText().isBlank() && !NetUtils.isMomocField(figure)) {
            log.warn((Object)"Tried to write formulas into invalid text figure! Nothing was written.");
            return null;
        }
        StringBuilder text = new StringBuilder(figure.getText());
        List<String> existingFormulas = Arrays.asList(figure.getText().split("\\r?\\n"));
        if (figure.getText().isBlank()) {
            text.append("momoc");
        }
        text.append("\n//Added from GUI:\n");
        formulas.stream().filter(it -> !existingFormulas.contains(it)).map(it -> {
            it = (String)it + "\n";
            return it;
        }).forEach(text::append);
        figure.setText(text.toString());
        return figure;
    }

    public static Collection<String> readFormulas(TextFigure figure) {
        if (!NetUtils.isMomocField(figure)) {
            log.info((Object)"Tried to read from an invalid text-figure.");
            return Collections.emptyList();
        }
        List<String> lines = Arrays.asList(figure.getText().split("\\r?\\n"));
        return lines.stream().filter(String::isBlank).filter(NetUtils::isComment).filter(it -> it.equalsIgnoreCase("momoc")).map(String::trim).collect(Collectors.toSet());
    }

    public static boolean isComment(String formula) {
        formula = formula.stripLeading();
        for (String symbol : GUIConstants.COMMENT_SYMBOLS) {
            if (!formula.startsWith(symbol)) continue;
            return true;
        }
        return false;
    }

    private NetUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

