/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.resultVisualization;

import CH.ifa.draw.util.Iconkit;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceDrawing;
import de.renew.momoc.elements.Graph;
import de.renew.net.NetInstance;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class WitnessReplayVisualizer
extends JFrame {
    private static final Logger log = Logger.getLogger(WitnessReplayVisualizer.class);
    private static final String IMAGES = "/resources/de.renew.momoc/images";
    private static final String START_ANIMATION_ICON_PATH = "/resources/de.renew.momoc/imagesstart.png";
    private static final String STOP_ANIMATION_ICON_PATH = "/resources/de.renew.momoc/imagesstop.png";
    private static final String PREVIOUS_STEP_ICON_PATH = "/resources/de.renew.momoc/imagesprevious.png";
    private static final String NEXT_STEP_ICON_PATH = "/resources/de.renew.momoc/imagesnext.png";
    private static final long ANIMATION_INTERVAL = 3L;
    private JPanel _buttonPanel;
    private JList<NetInstance> _instanceList;
    private Graph _reachabilityGraph;
    private Node _currentNode;
    private int _currentIndex;
    private DefaultListModel<NetInstance> _listModel;
    private short _formula;
    private JButton _previousButton;
    private JButton _animateButton;
    private JButton _nextButton;
    private List<Node> _witness;
    private final ScheduledExecutorService _scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> _beeperHandle;
    private ImageIcon _startAnimationIcon;
    private ImageIcon _stopAnimationIcon;

    public WitnessReplayVisualizer(Graph reachabilityGraph, short formula) {
        this._reachabilityGraph = reachabilityGraph;
        this._formula = formula;
        this._witness = this.reconstructWitness();
        this._currentIndex = 0;
        this._currentNode = this._witness.get(this._currentIndex);
        this.setLayout(new BorderLayout());
        this._buttonPanel = this.createButtonPanel();
        this.add((Component)this._buttonPanel, "First");
        this.updateButtons();
        this._instanceList = this.createInstanceList();
        JScrollPane scrollPane = new JScrollPane(this._instanceList);
        scrollPane.setMinimumSize(new Dimension(100, 200));
        this.add((Component)scrollPane, "Center");
        this.setDefaultCloseOperation(2);
    }

    private List<Node> reconstructWitness() {
        ArrayList<Node> witness = new ArrayList<Node>();
        Node startNode = this._reachabilityGraph.getStartNode();
        Optional<Node> currentNode = Optional.of(startNode);
        while (currentNode.isPresent()) {
            witness.add(currentNode.get());
            currentNode = currentNode.get().getEdges().stream().map(Edge::getTargetNode).filter(n -> n.hasLabel(Short.valueOf(-this._formula)) && !witness.contains(n)).findAny();
        }
        return witness;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        Iconkit.instance().registerImage(PREVIOUS_STEP_ICON_PATH);
        ImageIcon previousIcon = new ImageIcon(Iconkit.instance().getImage(PREVIOUS_STEP_ICON_PATH));
        this._previousButton = new JButton(previousIcon);
        this._previousButton.addActionListener(e -> this.previous());
        jPanel.add(this._previousButton);
        Iconkit.instance().registerImage(START_ANIMATION_ICON_PATH);
        this._startAnimationIcon = new ImageIcon(Iconkit.instance().getImage(START_ANIMATION_ICON_PATH));
        Iconkit.instance().registerImage(STOP_ANIMATION_ICON_PATH);
        this._stopAnimationIcon = new ImageIcon(Iconkit.instance().getImage(STOP_ANIMATION_ICON_PATH));
        this._animateButton = new JButton(this._startAnimationIcon);
        this._animateButton.addActionListener(e -> this.animateSteps());
        jPanel.add(this._animateButton);
        Iconkit.instance().registerImage(NEXT_STEP_ICON_PATH);
        ImageIcon nextIcon = new ImageIcon(Iconkit.instance().getImage(NEXT_STEP_ICON_PATH));
        this._nextButton = new JButton(nextIcon);
        this._nextButton.addActionListener(e -> this.next());
        jPanel.add(this._nextButton);
        return jPanel;
    }

    private JList<NetInstance> createInstanceList() {
        this._listModel = new DefaultListModel();
        ArrayList<NetInstance> netInstances = new ArrayList<NetInstance>(this._currentNode.getNetInstances());
        netInstances.sort(Comparator.comparing(Object::toString));
        this._listModel.addAll(netInstances);
        JList<NetInstance> list = new JList<NetInstance>(this._listModel);
        list.addMouseListener(new ListClickListener());
        return list;
    }

    public void showFrame() {
        this.setTitle("Witness Replay");
        this.setVisible(true);
        this.pack();
    }

    private void updateListAndViews() {
        this._listModel.removeAllElements();
        ArrayList<NetInstance> netInstances = new ArrayList<NetInstance>(this._currentNode.getNetInstances());
        netInstances.sort(Comparator.comparing(Object::toString));
        this._listModel.addAll(netInstances);
        try {
            for (NetInstance netInstance : netInstances) {
                NetInstanceAccessorImpl instanceAccessor = new NetInstanceAccessorImpl(netInstance, null);
                DrawingView instanceView = this.getViewForNetInstance((NetInstanceAccessor)instanceAccessor);
                if (instanceView == null) continue;
                Drawing oldDrawing = instanceView.drawing();
                InstanceDrawing newDrawing = CPNInstanceDrawing.getInstanceDrawing((NetInstanceAccessor)instanceAccessor);
                instanceView.setDrawing((Drawing)newDrawing);
                CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateButtons() {
        this._previousButton.setEnabled(this.hasPrevious());
        if (this.hasNext()) {
            this._nextButton.setEnabled(true);
            this._animateButton.setEnabled(true);
        } else {
            this._nextButton.setEnabled(false);
            this._animateButton.setEnabled(false);
        }
    }

    private boolean hasPrevious() {
        return this._currentIndex > 0;
    }

    private boolean hasNext() {
        return this._currentIndex < this._witness.size() - 1;
    }

    private void previous() {
        this._currentNode = this._witness.get(--this._currentIndex);
        this.updateListAndViews();
        this.updateButtons();
    }

    private void next() {
        this._currentNode = this._witness.get(++this._currentIndex);
        this.updateListAndViews();
        this.updateButtons();
    }

    public void animateSteps() {
        if (!this.isAnimationRunning()) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    private boolean isAnimationRunning() {
        return this._beeperHandle != null && !this._beeperHandle.isCancelled();
    }

    private void startAnimation() {
        Runnable beeper = new Runnable(){

            @Override
            public void run() {
                if (WitnessReplayVisualizer.this.hasNext()) {
                    WitnessReplayVisualizer.this.next();
                } else {
                    WitnessReplayVisualizer.this.stopAnimation();
                }
            }
        };
        this._beeperHandle = this._scheduler.scheduleAtFixedRate(beeper, 3L, 3L, TimeUnit.SECONDS);
        this._animateButton.setIcon(this._stopAnimationIcon);
    }

    public void stopAnimation() {
        if (this.isAnimationRunning()) {
            this._beeperHandle.cancel(false);
            this._animateButton.setIcon(this._startAnimationIcon);
        }
    }

    private DrawingView getViewForNetInstance(NetInstanceAccessor instanceAccessor) throws RemoteException {
        List instanceDrawings = Collections.list(GuiPlugin.getCurrent().getGui().drawings()).stream().filter(CPNInstanceDrawing.class::isInstance).map(CPNInstanceDrawing.class::cast).collect(Collectors.toList());
        for (CPNInstanceDrawing drawing : instanceDrawings) {
            if (!drawing.getNetInstance().asString().equals(instanceAccessor.asString())) continue;
            DrawingView view = GuiPlugin.getCurrent().getView((Drawing)drawing);
            return view;
        }
        return null;
    }

    class ListClickListener
    extends MouseAdapter {
        ListClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                try {
                    NetInstance netInstance = WitnessReplayVisualizer.this._instanceList.getSelectedValue();
                    NetInstanceAccessorImpl instanceAccessor = new NetInstanceAccessorImpl(netInstance, null);
                    DrawingView instanceView = WitnessReplayVisualizer.this.getViewForNetInstance((NetInstanceAccessor)instanceAccessor);
                    if (instanceView == null) {
                        GuiPlugin.getCurrent().openInstanceDrawing((NetInstanceAccessor)instanceAccessor);
                    } else {
                        GuiPlugin.getCurrent().getGui().showDrawingViewContainer(instanceView.drawing());
                    }
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

