/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.resultVisualization;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.LineConnection;
import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.Node;
import de.renew.rgbase.gui.Aborter;
import de.renew.rgbase.gui.GraphDrawing;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ColorizableGraphDrawing
extends GraphDrawing
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<Node> _nodes;
    private Node _startNode;
    private Map<Node, AttributeFigure> _nodeFigures;
    private Map<Edge, LineConnection> _edgeFigures;
    private Collection<LineConnection> _coloredEdges;
    private static final Color TRUE_INNER = new Color(230, 255, 225);
    private static final Color TRUE_BORDER = Color.GREEN;
    private static final Color FALSE_INNER = new Color(255, 200, 205);
    private static final Color FALSE_BORDER = Color.RED;
    private static final Color UNKNOWN = new Color(255, 225, 0);
    private static final int PATH_WIDTH = 3;

    public ColorizableGraphDrawing() {
    }

    public ColorizableGraphDrawing(Aborter aborter, Collection<Node> nodes, Node startNode, int inscMode, short formula, boolean displayEdgeInscriptions) {
        super(aborter, nodes, startNode, inscMode, displayEdgeInscriptions);
        this._nodes = nodes;
        this._startNode = startNode;
        if (formula != -1) {
            this.recolorByFormula(formula);
            Color c = startNode.hasLabel(Short.valueOf(formula)) ? Color.GREEN : Color.RED;
            this._nodeFigures.get(startNode).setFillColor(c);
            this._nodeFigures.get(startNode).setFrameColor(Color.BLACK);
        } else {
            this._nodeFigures.get(startNode).setFillColor(UNKNOWN);
        }
    }

    public void recolorByFormula(short formula) {
        for (Node node : this._nodes) {
            AttributeFigure figure;
            if (node != this._startNode) {
                figure = this._nodeFigures.get(node);
                figure.setFrameColor(node.hasLabel(Short.valueOf(formula)) ? TRUE_BORDER : FALSE_BORDER);
                figure.setFillColor(node.hasLabel(Short.valueOf(formula)) ? TRUE_INNER : FALSE_INNER);
                figure.setAttribute("LineWidth", (Object)(node.hasLabel(Short.valueOf(-formula)) ? 3 : 1));
                figure.changed();
                continue;
            }
            figure = this._nodeFigures.get(this._startNode);
            figure.setFillColor(this._startNode.hasLabel(Short.valueOf(formula)) ? Color.GREEN : Color.RED);
            figure.setFrameColor(Color.BLACK);
            figure.setAttribute("LineWidth", (Object)(node.hasLabel(Short.valueOf(-formula)) ? 3 : 1));
            figure.changed();
        }
        this.checkDamage();
    }

    public void colorTrace(Collection<Edge> trace, boolean positive) {
        this.uncolorEdges();
        if (trace != null && trace.size() > 0) {
            this._coloredEdges = new ArrayList<LineConnection>(trace.size());
            Color c = positive ? TRUE_BORDER : FALSE_BORDER;
            for (Edge edge : trace) {
                LineConnection connection = this._edgeFigures.get(edge);
                connection.setFrameColor(c);
                this._coloredEdges.add(connection);
            }
        }
    }

    private void uncolorEdges() {
        for (LineConnection edge : this._coloredEdges) {
            edge.setFrameColor(Color.BLACK);
        }
        this._coloredEdges = null;
    }

    protected void processConnection(Edge edge, LineConnection connection) {
        if (this._edgeFigures == null) {
            this._edgeFigures = new HashMap<Edge, LineConnection>();
        }
        this._edgeFigures.put(edge, connection);
    }

    protected void processNode(Node node, AttributeFigure nodeFig) {
        if (this._nodeFigures == null) {
            this._nodeFigures = new HashMap<Node, AttributeFigure>();
        }
        this._nodeFigures.put(node, nodeFig);
    }
}

