/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.environment;

import de.renew.momocgui.environment.ProcedureWithResult;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;

public class ProcedureAndResultManager {
    private final PropertyChangeSupport _support;
    private static ProcedureAndResultManager _singleton;
    private final ArrayList<ProcedureWithResult> _procedures = new ArrayList();

    private ProcedureAndResultManager() {
        this._support = new PropertyChangeSupport(this);
    }

    public static ProcedureAndResultManager getInstance() {
        if (_singleton == null) {
            _singleton = new ProcedureAndResultManager();
        }
        return _singleton;
    }

    public void register(ProcedureWithResult procedure) {
        this._procedures.add(procedure);
        procedure.addPropertyChangeListener(this::updateShownObjects);
        this.updateShownObjects(new PropertyChangeEvent(this, "new Procedure", null, procedure));
    }

    public void registerMultiple(Collection<ProcedureWithResult> procedureCollection) {
        this._procedures.addAll(procedureCollection);
        for (ProcedureWithResult procedure : procedureCollection) {
            procedure.addPropertyChangeListener(this::updateShownObjects);
        }
        this.updateShownObjects(new PropertyChangeEvent(this, "new Procedures", null, procedureCollection));
    }

    private void updateShownObjects(PropertyChangeEvent propertyChangeEvent) {
        this._support.firePropertyChange(propertyChangeEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public ArrayList<ProcedureWithResult> getRegisteredProcedures() {
        return this._procedures;
    }

    public ProcedureWithResult getAlreadyRegistered(String procedureName, String netName) {
        for (ProcedureWithResult p : this._procedures) {
            if (!p.toString().equals(procedureName) || !p.getNetName().equals(netName)) continue;
            return p;
        }
        return null;
    }

    public void remove(Collection<ProcedureWithResult> proceduresWithResult) {
        for (ProcedureWithResult p : proceduresWithResult) {
            p.initiateAbort();
        }
        this._procedures.removeAll(proceduresWithResult);
        this.updateShownObjects(new PropertyChangeEvent(this, "removed Procedures", proceduresWithResult, null));
    }
}

