/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.environment;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.MenuApi;
import de.renew.gui.CPNDrawing;
import de.renew.momoc.procedures.Procedure;
import de.renew.momoc.procedures.ProcedureCollector;
import de.renew.momoc.storageManagers.StorageManager;
import de.renew.momoc.storageManagers.StorageManagerCollector;
import de.renew.momocgui.commands.ParallelProcedureRunner;
import de.renew.momocgui.environment.DescriptionTextArea;
import de.renew.momocgui.environment.ProcedureListFrame;
import de.renew.momocgui.util.NetUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class EnvironmentFrame {
    private static final Logger log = Logger.getLogger(EnvironmentFrame.class);
    private static EnvironmentFrame _instance;
    private static final Dimension COLUMN_DIMENSION;
    private JFrame _frame;
    private JTextArea _procedureDescription;
    private JTextArea _storageDescription;
    private JPanel _additionalSettings;
    private JList _storageManagerList;
    private JPanel _container;
    private Procedure _selectedProcedure = null;
    private StorageManager _selectedStorageManager = null;
    private JButton _startButton;
    private JButton _showProcedureListButton;
    private JButton _syntaxCheckButton;
    private JButton _helpButton;
    private DescriptionTextArea _specTextArea;
    private DescriptionTextArea _macroTextArea;

    public static EnvironmentFrame getInstance() {
        if (_instance == null) {
            _instance = new EnvironmentFrame();
        }
        return _instance;
    }

    public void show() {
        if (this._frame == null) {
            this.createFrame();
        } else {
            this._frame.setVisible(true);
        }
    }

    private EnvironmentFrame() {
        this.createFrame();
    }

    private void createFrame() {
        this._frame = new JFrame("Modular Model Checker");
        this._frame.setLayout(new BoxLayout(this._frame.getContentPane(), 0));
        this._container = new JPanel();
        this._container.setLayout(new BorderLayout());
        this.createStoragePanel();
        JPanel selectionMenuPanel = this.createSelectionMenuPanel();
        JPanel procedurePanel = this.createProcedurePanel();
        this._container.add((Component)procedurePanel, "West");
        this._container.add((Component)selectionMenuPanel, "Center");
        this._frame.add(this._container);
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EnvironmentFrame.this.closeFrame();
            }
        });
        this._frame.pack();
        this._frame.setResizable(true);
        this._frame.setVisible(true);
    }

    private JPanel createProcedurePanel() {
        JPanel procedurePanel = new JPanel();
        procedurePanel.setBorder(BorderFactory.createTitledBorder("Procedures"));
        procedurePanel.setLayout(new GridLayout(2, 1));
        this._procedureDescription = this.createDescriptionDisplay("Select a procedure");
        procedurePanel.add(this.createProcedureList());
        procedurePanel.add(this._procedureDescription);
        return procedurePanel;
    }

    private JList createProcedureList() {
        JList list = new JList(new ProcedureListModel());
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        list.setSelectionMode(0);
        list.setPreferredSize(COLUMN_DIMENSION);
        list.addListSelectionListener(new ProcedureListSelectionHandler());
        list.setSelectedIndex(0);
        return list;
    }

    private JPanel createStoragePanel() {
        JPanel storagePanel = new JPanel();
        storagePanel.setBorder(BorderFactory.createTitledBorder("StorageManagers"));
        storagePanel.setLayout(new GridLayout(2, 1));
        storagePanel.add(this.createStorageList());
        this._storageDescription = this.createDescriptionDisplay("Select a storage manager");
        storagePanel.add(this._storageDescription);
        return storagePanel;
    }

    private JTextArea createDescriptionDisplay(String text) {
        JTextArea descriptionDisplay = new JTextArea(text);
        descriptionDisplay.setEditable(false);
        descriptionDisplay.setLineWrap(true);
        descriptionDisplay.setBackground(new JLabel().getBackground());
        descriptionDisplay.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Description"));
        descriptionDisplay.setMinimumSize(COLUMN_DIMENSION);
        return descriptionDisplay;
    }

    private JList createStorageList() {
        this._storageManagerList = new JList(new StorageManagerListModel());
        this._storageManagerList.setLayoutOrientation(0);
        this._storageManagerList.setVisibleRowCount(-1);
        this._storageManagerList.setSelectionMode(0);
        this._storageManagerList.addListSelectionListener(new ProcedureListSelectionHandler());
        this._storageManagerList.setMinimumSize(COLUMN_DIMENSION);
        return this._storageManagerList;
    }

    private JPanel createSelectionMenuPanel() {
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new GridLayout(3, 1));
        JPanel macroPanel = new JPanel();
        macroPanel.setLayout(new BorderLayout());
        macroPanel.setBorder(BorderFactory.createTitledBorder(null, "Macros"));
        this._macroTextArea = new DescriptionTextArea("Enter any number of macros...");
        this._macroTextArea.setToolTipText("<html>Enter macros in the form 'ID=formula'.<br>You can then use ID in the formula panel.<br>Seperate macros with line breaks.</html>");
        JScrollPane apScrollPane = new JScrollPane(this._macroTextArea);
        macroPanel.add((Component)apScrollPane, "Center");
        selectionPanel.add(macroPanel);
        JPanel specPanel = new JPanel();
        specPanel.setLayout(new BorderLayout());
        specPanel.setBorder(BorderFactory.createTitledBorder("Specification"));
        this._specTextArea = new DescriptionTextArea("Enter a formula...");
        JScrollPane specScrollPane = new JScrollPane(this._specTextArea);
        specPanel.add((Component)specScrollPane, "Center");
        selectionPanel.add(specPanel);
        JPanel buttonPanel = new JPanel();
        FlowLayout buttonPanelLayout = new FlowLayout();
        buttonPanelLayout.setAlignOnBaseline(true);
        buttonPanel.setLayout(buttonPanelLayout);
        this._startButton = new JButton("Start");
        this._startButton.setEnabled(false);
        this._startButton.addActionListener(e -> this.start());
        this._startButton.updateUI();
        this._startButton.setToolTipText("Starts the selected procedure");
        buttonPanel.add(this._startButton);
        this._syntaxCheckButton = new JButton("Syntax Check");
        this._syntaxCheckButton.addActionListener(e -> this.syntaxCheck(this.getFormulas()));
        this._syntaxCheckButton.setToolTipText("Checks the syntax of the entered specification");
        buttonPanel.add(this._syntaxCheckButton);
        this._showProcedureListButton = new JButton("Procedure List");
        this._showProcedureListButton.addActionListener(e -> ProcedureListFrame.show());
        this._showProcedureListButton.setToolTipText("Shows the list of all executed procedures.");
        buttonPanel.add(this._showProcedureListButton);
        this._helpButton = new JButton("?");
        try {
            URI helpUri = new URI("https://paose.informatik.uni-hamburg.de/paose/wiki/MoMoC");
            this._helpButton.addActionListener(e -> {
                boolean showPopup = true;
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(helpUri);
                        showPopup = false;
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
                if (showPopup) {
                    JOptionPane.showMessageDialog(this._frame, "For help, please visit https://paose.informatik.uni-hamburg.de/paose/wiki/MoMoC", "MoMoC Manual", 3);
                }
            });
            this._helpButton.setToolTipText("Opens the MoMoC manual in your browser.");
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
            this._helpButton.setToolTipText("Something went wrong with the help page.");
            this._helpButton.setEnabled(false);
        }
        buttonPanel.add(this._helpButton);
        buttonPanel.setPreferredSize(new Dimension(80, 50));
        selectionPanel.add(buttonPanel);
        selectionPanel.setMinimumSize(COLUMN_DIMENSION);
        selectionPanel.setPreferredSize(COLUMN_DIMENSION);
        return selectionPanel;
    }

    private void syntaxCheck(String[] formulas) {
        for (String formula : formulas) {
            this.syntaxCheck(formula);
        }
    }

    private void syntaxCheck(String formula) {
        String result = this._selectedProcedure.checkSyntax(formula);
        JOptionPane.showMessageDialog(null, result, "Syntax Check: " + formula, -1);
    }

    private String[] getFormulas() {
        String[] guiFormulas = this.getGUIFormulas();
        HashSet<String> netFormulas = EnvironmentFrame.getNetFormulas();
        netFormulas.addAll(Arrays.asList(guiFormulas));
        return (String[])netFormulas.stream().filter(it -> !it.isBlank()).toArray(String[]::new);
    }

    private String[] getGUIFormulas() {
        String baseFormula = this._specTextArea.getText();
        if (this._macroTextArea.hasText()) {
            String[] macros;
            String macroField = this._macroTextArea.getText().trim();
            for (String s : macros = macroField.split("\\r?\\n")) {
                if ((s = s.replaceAll("\\s", "")).equals("")) continue;
                int eqIndex = s.indexOf("=");
                String identifier = s.substring(0, eqIndex);
                String replaceText = s.substring(eqIndex + 1);
                baseFormula = baseFormula.replaceAll(identifier, replaceText);
            }
        }
        return baseFormula.split("\\r?\\n");
    }

    public static HashSet<String> getNetFormulas() {
        HashSet<String> formulas = new HashSet<String>();
        DrawApplication app = DrawPlugin.getGui();
        Drawing drawing = app.drawing();
        if (!(drawing instanceof CPNDrawing)) {
            return formulas;
        }
        FigureEnumeration figures = drawing.figures();
        Iterator it = figures.asIterator();
        while (it.hasNext()) {
            Figure figure = (Figure)it.next();
            if (!(figure instanceof TextFigure)) continue;
            formulas.addAll(NetUtils.readFormulas((TextFigure)figure));
        }
        return formulas;
    }

    private void enableStorageSelection(boolean flag) {
        this._storageManagerList.setEnabled(flag);
        if (!flag) {
            this._storageDescription.setText("The selected procedure does not allow a custom storage manager.");
        } else {
            this._storageDescription.setText("Select a storage manager");
        }
    }

    private void updateAdditionalSettingsPanel(JPanel newPanel) {
        if (this._additionalSettings != null) {
            this._container.remove(this._additionalSettings);
        }
        this._additionalSettings = newPanel;
        for (Component c : this._container.getComponents()) {
            if (!(c instanceof JPanel)) continue;
            c.setPreferredSize(c.getSize());
        }
        if (this._additionalSettings != null) {
            this._container.add((Component)this._additionalSettings, "East");
        }
        this._frame.pack();
        this._frame.repaint();
    }

    private void setSelectedProcedure(Procedure selectedProcedure) {
        this._selectedProcedure = selectedProcedure;
        this._startButton.setEnabled(this._selectedProcedure != null);
        this._syntaxCheckButton.setEnabled(this._selectedProcedure.usesFormulas());
        this._specTextArea.setEnabled(this._selectedProcedure.usesFormulas());
        this._macroTextArea.setEnabled(this._selectedProcedure.usesFormulas());
    }

    private void start() {
        new Thread(new ParallelProcedureRunner(this._selectedProcedure, this.getFormulas())).start();
    }

    private synchronized void closeFrame() {
        if (this._frame != null) {
            this._frame.setVisible(false);
            MenuApi.unregisterWindowsMenuFrame((Frame)this._frame);
            this._frame = null;
            ProcedureListFrame.close();
        }
    }

    static {
        COLUMN_DIMENSION = new Dimension(210, 150);
    }

    static class ProcedureListModel
    extends AbstractListModel {
        ProcedureListModel() {
        }

        @Override
        public int getSize() {
            return ProcedureCollector.getInstance().getRegisteredProcedures().size();
        }

        @Override
        public Object getElementAt(int index) {
            return ((ProcedureCollector.ProcedureFactory)ProcedureCollector.getInstance().getRegisteredProcedures().get(index)).getProcedure();
        }
    }

    class ProcedureListSelectionHandler
    implements ListSelectionListener {
        ProcedureListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = ((JList)e.getSource()).getSelectedIndex();
            EnvironmentFrame.this.setSelectedProcedure(((ProcedureCollector.ProcedureFactory)ProcedureCollector.getInstance().getRegisteredProcedures().get(index)).getProcedure());
            String description = EnvironmentFrame.this._selectedProcedure.description();
            EnvironmentFrame.this._procedureDescription.setText(description);
            EnvironmentFrame.this.enableStorageSelection(EnvironmentFrame.this._selectedProcedure.allowCustomStorageManager());
            JPanel parametersPanel = EnvironmentFrame.this._selectedProcedure.additionalParameterSettings();
            if (parametersPanel != null) {
                parametersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createDashedBorder(null), "Procedure Settings"));
            }
            EnvironmentFrame.this.updateAdditionalSettingsPanel(parametersPanel);
        }
    }

    static class StorageManagerListModel
    extends AbstractListModel {
        StorageManagerListModel() {
        }

        @Override
        public int getSize() {
            return StorageManagerCollector.getInstance().getRegisteredStorageManagers().size();
        }

        @Override
        public Object getElementAt(int index) {
            return ((StorageManagerCollector.StorageManagerFactory)StorageManagerCollector.getInstance().getRegisteredStorageManagers().get(index)).getStorageManager();
        }
    }
}

