/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momocgui.commands;

import de.renew.momoc.core.NetLoader;
import de.renew.momoc.core.Result;
import de.renew.momoc.procedures.Procedure;
import de.renew.momoc.util.MomocConfigurationException;
import de.renew.momocgui.environment.GUIAborter;
import de.renew.momocgui.environment.ProcedureAndResultManager;
import de.renew.momocgui.environment.ProcedureListFrame;
import de.renew.momocgui.environment.ProcedureWithResult;
import de.renew.net.Net;
import de.renew.rgbase.gui.Aborter;
import de.renew.simulator.api.SimulationLockExecutor;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ParallelProcedureRunner
implements Runnable {
    private static final Logger log = Logger.getLogger(ParallelProcedureRunner.class);
    private final Procedure _selectedProcedure;
    private String _netName = null;
    private final String[] _formulas;
    private static final String ABORT_MESSAGE = "Procedure was aborted. Nothing to show.";

    public ParallelProcedureRunner(Procedure selectedProcedure, String[] formulas) {
        this._selectedProcedure = selectedProcedure;
        this._formulas = formulas;
    }

    public ParallelProcedureRunner(Procedure selectedProcedure, String nameOfNet, String[] formulas) {
        this._selectedProcedure = selectedProcedure;
        this._netName = nameOfNet;
        this._formulas = formulas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info((Object)("Initialising start of a " + String.valueOf(this._selectedProcedure)));
        SimulationLockExecutor.lock();
        try {
            Net net;
            if (this._netName == null || this._netName.isBlank()) {
                net = NetLoader.loadNet();
                if (net != null) {
                    this._netName = net.getName();
                }
            } else {
                net = NetLoader.loadNet((String)this._netName);
            }
            if (net != null) {
                ProcedureListFrame.show();
                if (!this._selectedProcedure.usesFormulas()) {
                    GUIAborter aborter = new GUIAborter();
                    ProcedureWithResult procedureWithResult = ProcedureAndResultManager.getInstance().getAlreadyRegistered(this._selectedProcedure.toString(), this._netName);
                    if (procedureWithResult == null) {
                        procedureWithResult = new ProcedureWithResult(this._selectedProcedure.toString(), this._netName, this._selectedProcedure, aborter);
                        ProcedureAndResultManager.getInstance().register(procedureWithResult);
                    } else {
                        procedureWithResult.initiateAbort();
                        procedureWithResult.setResult(null);
                        aborter = procedureWithResult.getAborter();
                        aborter.reset();
                    }
                    Result result = this._selectedProcedure.start(net, (Aborter)aborter, "");
                    if (aborter.abort()) {
                        log.info((Object)ABORT_MESSAGE);
                    } else {
                        procedureWithResult.setResult(result);
                    }
                } else {
                    for (String formula : this._formulas) {
                        if (this._selectedProcedure.checkSyntax(formula).equals("Syntax is correct")) {
                            GUIAborter aborter = new GUIAborter();
                            ProcedureWithResult procedureWithResult = ProcedureAndResultManager.getInstance().getAlreadyRegistered(formula, this._netName);
                            if (procedureWithResult == null) {
                                procedureWithResult = new ProcedureWithResult(formula, this._netName, this._selectedProcedure, aborter);
                                ProcedureAndResultManager.getInstance().register(procedureWithResult);
                            } else {
                                procedureWithResult.initiateAbort();
                                procedureWithResult.setResult(null);
                                aborter = procedureWithResult.getAborter();
                                aborter.reset();
                            }
                            Result result = this._selectedProcedure.start(net, (Aborter)aborter, formula);
                            if (aborter.abort()) {
                                log.info((Object)ABORT_MESSAGE);
                                continue;
                            }
                            procedureWithResult.setResult(result);
                            continue;
                        }
                        log.warn((Object)(formula + " does not conform with the " + String.valueOf(this._selectedProcedure) + " syntax and is ignored."));
                    }
                }
            }
        }
        catch (MomocConfigurationException e) {
            log.error((Object)e.getMessage(), e.fillInStackTrace());
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error during procedure", 0);
        }
        finally {
            SimulationLockExecutor.unlock();
            log.info((Object)(String.valueOf(this._selectedProcedure) + " terminated, simulator unlocked."));
        }
    }
}

