/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import CH.ifa.draw.DrawPlugin;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorConfigurator;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.events.DirectoryOpeningEvent;
import de.renew.navigator.gui.DefaultFileTreeCellRenderer;
import de.renew.navigator.gui.DragDropListener;
import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.gui.TreeExpansionListener;
import de.renew.navigator.gui.TreeKeyListener;
import de.renew.navigator.gui.TreeMouseListener;
import de.renew.navigator.gui.actions.AddFilesAction;
import de.renew.navigator.gui.actions.CollapseAllAction;
import de.renew.navigator.gui.actions.ExpandAction;
import de.renew.navigator.gui.actions.OpenHomeAction;
import de.renew.navigator.gui.actions.OpenNetPathAction;
import de.renew.navigator.gui.actions.RefreshAllAction;
import de.renew.navigator.gui.actions.RemoveAllAction;
import de.renew.navigator.gui.actions.RemoveOneAction;
import de.renew.navigator.gui.filters.JavaSearchFilter;
import de.renew.navigator.gui.filters.RNWSearchFilter;
import de.renew.navigator.models.BackgroundTask;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.Model;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;
import de.renew.navigator.models.TreeElement;
import de.renew.util.StringUtil;
import de.renew.windowmanagement.Workbench;
import de.renew.windowmanagement.WorkbenchImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

class NavigatorGuiImpl
implements NavigatorGui,
Observer {
    public static final long serialVersionUID = 97936353687387679L;
    private static final Logger LOGGER = Logger.getLogger(NavigatorGuiImpl.class);
    private final FilesystemController _filesystem;
    private final NavigatorFileTree _model;
    private final List<NavigatorAction> _actions;
    private final JPanel _menuPanel = new JPanel();
    private final JTextField _searchField = new JTextField();
    private final DefaultMutableTreeNode _rootNode = new DefaultMutableTreeNode("rootNode");
    private final DefaultTreeModel _treeModel = new DefaultTreeModel(this._rootNode);
    private final JTree _tree = new JTree(this._treeModel);
    private final JPanel _filterPanel = new JPanel();
    private final JPanel _tasksPanel = new JPanel();
    private final HashMap<NavigatorAction, Component> _actionMapper = new HashMap();
    private final DefaultFileTreeCellRenderer _treeCellRenderer = new DefaultFileTreeCellRenderer();
    private final List<NavigatorExtension> _extensions;
    public boolean _initialized = false;
    private boolean _updating = false;
    private final JPanel _pane;
    private final DefaultSingleCDockable _dockable;
    private final Workbench _workbench;

    public NavigatorGuiImpl(FilesystemController filesystem, Workbench workbench, NavigatorPlugin plugin) {
        this._model = plugin.getModel();
        this._model.addObserver(this);
        this._actions = new ArrayList<NavigatorAction>();
        this._filesystem = filesystem;
        this._extensions = new LinkedList<NavigatorExtension>();
        this._pane = new JPanel();
        this._pane.setPreferredSize(new Dimension(320, 640));
        Dimension barDimension = new Dimension(-1, 20);
        this._pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.ipadx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this._menuPanel.setLayout(new BoxLayout(this._menuPanel, 2));
        this._menuPanel.setPreferredSize(barDimension);
        this._menuPanel.setMaximumSize(barDimension);
        c.gridy = 0;
        this._pane.add((Component)this._menuPanel, c);
        this.initMenuBar();
        this._filterPanel.setLayout(new BoxLayout(this._filterPanel, 2));
        this._filterPanel.setPreferredSize(barDimension);
        this._filterPanel.setMaximumSize(barDimension);
        c.gridy = 1;
        this._pane.add((Component)this._filterPanel, c);
        this.initFilterBar();
        TreeMouseListener treeMouseListener = new TreeMouseListener(this);
        TreeKeyListener treeKeyListener = new TreeKeyListener(this);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setRootVisible(false);
        this._tree.setFocusable(true);
        this._tree.getSelectionModel().setSelectionMode(4);
        this._tree.addMouseListener(treeMouseListener);
        this._tree.addKeyListener(treeKeyListener);
        this._tree.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        this._tree.setCellRenderer(this._treeCellRenderer);
        this._tree.setLargeModel(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setAlignmentX(0.0f);
        panel.setBackground(Color.WHITE);
        panel.add((Component)this._tree, "Before");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        c.gridy = 2;
        c.weighty = 1.0;
        this._pane.add((Component)scrollPane, c);
        c.weighty = 0.0;
        c.gridy = 3;
        c.anchor = 20;
        this._tasksPanel.setLayout(new BoxLayout(this._tasksPanel, 3));
        this._pane.add((Component)this._tasksPanel, c);
        this._tree.addTreeExpansionListener(new TreeExpansionListener(this._model));
        new DropTarget(this._pane, (DropTargetListener)((Object)new DragDropListener(filesystem)));
        this._initialized = true;
        this._dockable = new DefaultSingleCDockable("Navigator", (Component)this._pane, new CAction[0]);
        this._dockable.setCloseable(true);
        this._workbench = workbench;
        workbench.addViewWindow(this._dockable, WorkbenchImpl.LOWER_LEFT_GROUP);
        this.updateGui(true);
    }

    @Override
    public void openWindow() {
        if (this._dockable.isVisible()) {
            this._dockable.toFront();
            return;
        }
        this._dockable.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this._workbench.close((SingleCDockable)this._dockable);
    }

    public void updateGui(boolean doUpdateSearchFilter) {
        SearchFilter searchFilter;
        if (this._updating) {
            return;
        }
        this._updating = true;
        this.closeAll();
        for (TreeElement treeRoot : this._model.getTreeRoots()) {
            FileTreeNode node = this.renderNode(treeRoot);
            if (node == null) continue;
            this._rootNode.add(node);
        }
        this.updateTree();
        this.expandFromModel();
        if (doUpdateSearchFilter && (searchFilter = this._model.getTextSearch()) != null && searchFilter.getTerms().size() > 0) {
            String term = searchFilter.getTerms().get(0);
            this._searchField.setText(term);
        }
        this.updateBackgroundTasks();
        this._pane.repaint();
        this._updating = false;
    }

    @Override
    public void addExtension(NavigatorExtension extension) {
        this._extensions.add(extension);
        extension.configure(new NavigatorConfigurator(){

            @Override
            public void addMenuAction(NavigatorAction action) {
                if (NavigatorGuiImpl.this._actionMapper.containsKey(action)) {
                    return;
                }
                NavigatorGuiImpl.this._actionMapper.put(action, NavigatorGuiImpl.this.createButton(NavigatorGuiImpl.this._menuPanel, action));
            }

            @Override
            public void addFilterAction(NavigatorAction action) {
                if (NavigatorGuiImpl.this._actionMapper.containsKey(action)) {
                    return;
                }
                NavigatorGuiImpl.this._actionMapper.put(action, NavigatorGuiImpl.this.createButton(NavigatorGuiImpl.this._filterPanel, action));
            }

            @Override
            public void addFileTreeCellRenderer(FileTreeCellRenderer renderer) {
                NavigatorGuiImpl.this._treeCellRenderer.addAdditionalRenderer(renderer);
            }
        });
    }

    @Override
    public boolean removeExtension(NavigatorExtension extension) {
        if (!this._extensions.remove(extension)) {
            return false;
        }
        extension.configure(new NavigatorConfigurator(){

            @Override
            public void addMenuAction(NavigatorAction action) {
                NavigatorGuiImpl.this._menuPanel.remove(NavigatorGuiImpl.this._actionMapper.remove(action));
            }

            @Override
            public void addFilterAction(NavigatorAction action) {
                NavigatorGuiImpl.this._filterPanel.remove(NavigatorGuiImpl.this._actionMapper.remove(action));
            }

            @Override
            public void addFileTreeCellRenderer(FileTreeCellRenderer renderer) {
                NavigatorGuiImpl.this._treeCellRenderer.removeAdditionalRenderer(renderer);
            }
        });
        this._pane.repaint();
        return true;
    }

    @Override
    public DefaultFileTreeCellRenderer getTreeCellRenderer() {
        return this._treeCellRenderer;
    }

    public void initFilterBar() {
        this._searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String param = NavigatorGuiImpl.this._searchField.getText();
                if (param.isEmpty()) {
                    NavigatorGuiImpl.this._model.setTextSearch(null);
                } else {
                    NavigatorGuiImpl.this._model.setTextSearch(new SearchFilter("search", SearchFilter.Type.CONTAINS, false, param));
                }
                NavigatorGuiImpl.this._model.notifyObservers(NavigatorGuiImpl.this._searchField);
            }
        });
        Dimension searchFieldDimension = new Dimension(198, 20);
        this._searchField.setMaximumSize(searchFieldDimension);
        this._searchField.setPreferredSize(searchFieldDimension);
        this._searchField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._filterPanel.add(this._searchField);
        this.createButton(this._filterPanel, new NavigatorAction("Clear Filter", "/de/renew/navigator/images/clear.png", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorGuiImpl.this._model.setTextSearch(null);
                NavigatorGuiImpl.this._searchField.setText("");
                NavigatorGuiImpl.this._model.notifyObservers(NavigatorGuiImpl.this._searchField);
            }
        });
        this.createButton(this._filterPanel, (NavigatorAction)new RNWSearchFilter(this._model));
        this.createButton(this._filterPanel, (NavigatorAction)new JavaSearchFilter(this._model));
    }

    @Deprecated
    public JButton createButton(String context, NavigatorAction action) {
        return this.createButton(this.getPanelForContext(context), action);
    }

    private JButton createButton(JPanel panel, NavigatorAction action) {
        Dimension buttonDimension = new Dimension(33, 20);
        final JButton menuButton = new JButton(action);
        menuButton.setMinimumSize(buttonDimension);
        menuButton.setPreferredSize(buttonDimension);
        menuButton.setAlignmentX(0.0f);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getPropertyName().equals("active")) {
                    return;
                }
                boolean newValue = (Boolean)propertyChangeEvent.getNewValue();
                menuButton.setSelected(newValue);
            }
        });
        panel.add(menuButton);
        panel.validate();
        panel.repaint();
        return menuButton;
    }

    public List<FileTreeNode> getSelectedNodes() {
        TreePath[] selectionPaths;
        ArrayList<FileTreeNode> result = new ArrayList<FileTreeNode>();
        for (TreePath path : selectionPaths = this.getSelectedTreePaths()) {
            Object component = path.getLastPathComponent();
            if (!(component instanceof FileTreeNode)) continue;
            result.add((FileTreeNode)component);
        }
        return result;
    }

    public TreePath[] getSelectedTreePaths() {
        TreePath[] selectionPaths = this._tree.getSelectionPaths();
        return selectionPaths == null ? new TreePath[]{} : selectionPaths;
    }

    public void openSelected() {
        TreePath[] paths;
        for (TreePath path : paths = this.getSelectedTreePaths()) {
            FileTreeNode ftn;
            File file;
            Object o = path.getLastPathComponent();
            if (o == null || !(o instanceof FileTreeNode) || (file = (ftn = (FileTreeNode)o).getFile()).isDirectory()) continue;
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (NavigatorGuiImpl.this._filesystem.isExternallyOpenedFile(file)) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop platform = Desktop.getDesktop();
                                platform.open(file);
                            }
                            catch (IOException | UnsupportedOperationException exception) {
                                String fileExtension = StringUtil.getExtension((String)file.getName());
                                DrawingEditor gui = DrawPlugin.getCurrent().getDrawingEditor();
                                gui.showStatus("Error: Files of type ." + fileExtension + " cannot be opened by renew on this platform.");
                            }
                        } else {
                            String fileExtension = StringUtil.getExtension((String)file.getName());
                            DrawingEditor gui = DrawPlugin.getCurrent().getDrawingEditor();
                            gui.showStatus("Error: Files of type ." + fileExtension + " cannot be opened by renew on this platform.");
                        }
                    } else {
                        DrawPlugin.getGui().openOrLoadDrawing(file.getPath());
                    }
                    return null;
                }
            };
            worker.execute();
        }
    }

    public void showContextMenu(int x, int y) {
        String os;
        TreePath path = this._tree.getPathForLocation(x, y);
        if (null == path) {
            return;
        }
        Object o = path.getLastPathComponent();
        if (o == null || !(o instanceof FileTreeNode)) {
            return;
        }
        final FileTreeNode mtn = (FileTreeNode)o;
        JPopupMenu popupMenu = new JPopupMenu();
        if (mtn.getParent() == this._rootNode) {
            RemoveOneAction action = new RemoveOneAction(this, this._model);
            JMenuItem menuItem = new JMenuItem(action);
            menuItem.setText(action.getActionName());
            popupMenu.add(menuItem);
        }
        String explorer = (os = System.getProperty("os.name")).equals("Mac OS X") ? "Finder" : "Explorer";
        JMenuItem reveal = new JMenuItem("Reveal in " + explorer);
        reveal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    File file = mtn.getFile();
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    desktop.open(file);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, "Could not reveal.");
                }
            }
        });
        popupMenu.add(reveal);
        for (NavigatorExtension extension : this._extensions) {
            JMenuItem menuItem2 = extension.getMenuItem(this._tree, x, y, o, mtn);
            if (menuItem2 == null) continue;
            popupMenu.add(menuItem2);
            popupMenu.repaint();
        }
        popupMenu.show(this._tree, x, y);
    }

    public void closeAll() {
        this._rootNode.removeAllChildren();
        this._treeModel.nodeStructureChanged(this._rootNode);
    }

    @Override
    public void collapseAll() {
        LOGGER.debug((Object)"------------> COLLAPSE ALL");
        for (TreeElement rootDirectory : this._model.getTreeRoots()) {
            if (!(rootDirectory instanceof Directory)) continue;
            ((Directory)rootDirectory).setOpened(false);
        }
        this._model.notifyObservers();
    }

    @Override
    public void expand() {
        LOGGER.debug((Object)"------------> EXPAND RECURSIVE");
        try {
            TreePath path = this._tree.getSelectionPath();
            TreeExpansionListener.setActive(false);
            if (path != null) {
                FileTreeNode tn = (FileTreeNode)path.getLastPathComponent();
                TreeElement treeElement = tn.getModel();
                if (treeElement instanceof Directory) {
                    treeElement.expandAll();
                } else {
                    Model parent = treeElement.getParent();
                    if (parent instanceof Directory) {
                        ((Directory)parent).expandAll();
                    }
                }
            } else {
                this._model.expandAll();
            }
            this._model.notifyObservers();
            TreeExpansionListener.setActive(true);
            this._tree.fireTreeExpanded(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeSelectedNodes() {
        List<TreeElement> selectedElements = this.getSelectedElements();
        for (TreeElement treeElement : selectedElements) {
            if (treeElement.getParent() instanceof NavigatorFileTree) {
                this._model.remove(treeElement);
                continue;
            }
            treeElement.setExcluded(true);
        }
        this._model.notifyObservers();
    }

    @Override
    public List<TreeElement> getSelectedElements() {
        LinkedList<TreeElement> elements = new LinkedList<TreeElement>();
        List<FileTreeNode> selectedNodes = this.getSelectedNodes();
        for (FileTreeNode node : selectedNodes) {
            elements.add(node.getModel());
        }
        return elements;
    }

    @Override
    public JTree getTree() {
        return this._tree;
    }

    @Override
    public DefaultMutableTreeNode getRootNode() {
        return this._rootNode;
    }

    public void removeMenuButton(JButton button) {
        this._menuPanel.remove(button);
        this._menuPanel.validate();
        this._menuPanel.repaint();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(NavigatorGuiImpl.class.getSimpleName() + ": removing button: " + String.valueOf(button)));
        }
    }

    public List<NavigatorAction> getActions() {
        return this._actions;
    }

    public void updateBackgroundTasks() {
        this._tasksPanel.removeAll();
        for (BackgroundTask task : this._model.getBackgroundTasks()) {
            this.renderTask(task);
        }
        this._tasksPanel.revalidate();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this._model) {
            if (arg instanceof DirectoryOpeningEvent) {
                DirectoryOpeningEvent event = (DirectoryOpeningEvent)arg;
                this.toggleNode(event.getNode(), event.isOpening());
                return;
            }
            this.updateGui(arg != this._searchField);
        }
    }

    @Override
    public List<NavigatorExtension> getExtensions() {
        return this._extensions;
    }

    private void toggleNode(FileTreeNode node, boolean opening) {
        if (opening) {
            this._tree.expandPath(node.getPath());
            return;
        }
        this._tree.collapsePath(node.getPath());
    }

    private void updateTree() {
        this._treeModel.reload();
        this._pane.validate();
        this._pane.repaint();
    }

    private void expandFromModel() {
        for (int i = 0; i < this._rootNode.getChildCount(); ++i) {
            FileTreeNode treeNode = (FileTreeNode)this._rootNode.getChildAt(i);
            for (FileTreeNode openedDir : treeNode.getOpenedDirectories()) {
                TreePath path = openedDir.getPath();
                this._tree.expandPath(path);
            }
        }
    }

    private void renderTask(final BackgroundTask task) {
        JPanel panel = new JPanel();
        JPanel leftPanel = new JPanel();
        final JLabel label = new JLabel(task.getName());
        final JButton cancel = new JButton();
        final JProgressBar progressBar = new JProgressBar();
        Observer observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (o instanceof BackgroundTask) {
                    BackgroundTask bg = (BackgroundTask)o;
                    label.setText(bg.getName() + " " + Math.round(bg.getCurrent() * 100.0f) + " %");
                    cancel.setEnabled(bg.isCancelable());
                    progressBar.setMinimum(0);
                    progressBar.setMaximum(Integer.MAX_VALUE);
                    progressBar.setValue(Math.round(bg.getCurrent() * 2.1474836E9f));
                    progressBar.setIndeterminate(bg.isIndeterminate());
                }
            }
        };
        task.addObserver(observer);
        observer.update(task, null);
        panel.setMinimumSize(new Dimension(-1, 50));
        panel.setLayout(new BoxLayout(panel, 2));
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        label.setLabelFor(progressBar);
        label.setBackground(Color.RED);
        leftPanel.add(label);
        progressBar.setBackground(Color.BLUE);
        leftPanel.add(progressBar);
        panel.add(leftPanel);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        cancel.setAction(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                task.cancel();
            }
        });
        panel.add(cancel);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._tasksPanel.add(panel);
    }

    private void initMenuBar() {
        this.createButton(this._menuPanel, (NavigatorAction)new OpenHomeAction(this._filesystem));
        this.createButton(this._menuPanel, (NavigatorAction)new OpenNetPathAction(this._filesystem));
        this.createButton(this._menuPanel, (NavigatorAction)new AddFilesAction(this._filesystem));
        this.createButton(this._menuPanel, (NavigatorAction)new ExpandAction(this));
        this.createButton(this._menuPanel, (NavigatorAction)new CollapseAllAction(this));
        this.createButton(this._menuPanel, (NavigatorAction)new RefreshAllAction(this._filesystem));
        this.createButton(this._menuPanel, (NavigatorAction)new RemoveOneAction(this, this._model));
        this.createButton(this._menuPanel, (NavigatorAction)new RemoveAllAction(this._model));
    }

    private void expandRecursively(TreePath tp, TreeNode tn) {
        Enumeration<? extends TreeNode> children = tn.children();
        while (children.hasMoreElements()) {
            TreeNode child;
            TreeNode o = children.nextElement();
            if (!(o instanceof TreeNode) || (child = o).isLeaf()) continue;
            this.expandRecursively(tp.pathByAddingChild(child), child);
        }
        this._tree.expandPath(tp);
    }

    @Deprecated
    private JPanel getPanelForContext(String context) {
        if (context.equals("menu")) {
            return this._menuPanel;
        }
        return this._filterPanel;
    }

    private FileTreeNode renderNode(TreeElement model) {
        if (model.isExcluded()) {
            return null;
        }
        if (model instanceof Directory) {
            return this.renderDirectoryModel((Directory)model);
        }
        if (model instanceof Leaf) {
            return this.renderFileNode((Leaf)model);
        }
        throw new RuntimeException("model must be either File or Directory.");
    }

    private FileTreeNode renderDirectoryModel(Directory model) {
        FileTreeNode treeNode = new FileTreeNode(model);
        int numChildren = 0;
        for (TreeElement child : model.getChildren()) {
            FileTreeNode node = this.renderNode(child);
            if (node == null) continue;
            treeNode.add(node);
            ++numChildren;
        }
        if (numChildren == 0) {
            return null;
        }
        return treeNode;
    }

    private FileTreeNode renderFileNode(Leaf model) {
        return this.shouldRenderFileNode(model) ? new FileTreeNode(model) : null;
    }

    private boolean shouldRenderFileNode(Leaf model) {
        int numFilters = 0;
        String toMatch = model.getName();
        if (this._model.getTextSearch() != null && !this._model.getTextSearch().match(toMatch)) {
            return false;
        }
        for (SearchFilter filter : this._model.getActiveFileFilters()) {
            if (!filter.isValid()) continue;
            ++numFilters;
            if (!filter.match(toMatch)) continue;
            return true;
        }
        return numFilters == 0;
    }
}

