/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.TreeElement;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeCellRenderer;

class DefaultFileTreeCellRenderer
extends FileTreeCellRenderer {
    private final HashMap<String, Icon> _icons = new HashMap();
    private Icon _defaultIcon = null;

    public DefaultFileTreeCellRenderer() {
        this.setDefaultIcon("/de/renew/navigator/images/files/file.png");
        this.addIcon(".aip", "/de/renew/navigator/images/files/file-aip.png");
        this.addIcon(".draw", "/de/renew/navigator/images/files/file-draw.png");
        this.addIcon(".rnw", "/de/renew/navigator/images/files/file-net.png");
        this.addIcon(".net", "/de/renew/navigator/images/files/file-net.png");
        this.addIcon(".pnml", "/de/renew/navigator/images/files/file-net.png");
        this.addIcon(".arm", "/de/renew/navigator/images/files/file-arm.png");
        this.addIcon(".mad", "/de/renew/navigator/images/files/file-arm.png");
        this.addIcon(".java", "/de/renew/navigator/images/files/file-java.png");
        this.addIcon("build.xml", "/de/renew/navigator/images/files/file-ant.png");
        this.addIcon(".xml", "/de/renew/navigator/images/files/file-xml.png");
        this.addIcon(".xmi", "/de/renew/navigator/images/files/file-xml.png");
        this.addIcon(".md", "/de/renew/navigator/images/files/file-markdown.png");
        this.addIcon(".markdown", "/de/renew/navigator/images/files/file-markdown.png");
    }

    public void setDefaultIcon(String filename) {
        this._defaultIcon = DefaultFileTreeCellRenderer.loadIcon(filename);
    }

    public Icon addIcon(String key, String filename) {
        return this._icons.put(key, DefaultFileTreeCellRenderer.loadIcon(filename));
    }

    @Override
    public void render(DefaultTreeCellRenderer target, TreeElement element, boolean selected, boolean expanded) {
        if (this._defaultIcon != null) {
            target.setIcon(this._defaultIcon);
        }
        target.setToolTipText(element.getFile().getAbsolutePath());
        if (element instanceof Leaf) {
            this.renderLeaf(target, (Leaf)element);
        }
        if (element instanceof Directory) {
            this.renderDirectory(target, (Directory)element, expanded);
        }
    }

    private void renderLeaf(DefaultTreeCellRenderer target, Leaf leaf) {
        String name = leaf.getFile().getName();
        if (name.contains("_DC") || name.contains("DC_")) {
            DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/files/file-dc.png");
            return;
        }
        if (name.contains("Ontology")) {
            DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/files/file-ontology.png");
            return;
        }
        for (String key : this._icons.keySet()) {
            if (!name.endsWith(key)) continue;
            Icon fileIcon = this._icons.get(key);
            target.setIcon(fileIcon);
            break;
        }
    }

    private void renderDirectory(DefaultTreeCellRenderer target, Directory directory, boolean expanded) {
        if (directory.getType() == null) {
            if (expanded) {
                DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/pile-opened.png");
            } else {
                DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/pile-closed.png");
            }
            return;
        }
        switch (directory.getType()) {
            case PACKAGE: {
                DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/package.png");
                return;
            }
            case PLUGIN: {
                if (expanded) {
                    DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/plugin-opened.png");
                } else {
                    DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/plugin-closed.png");
                }
                target.setFont(new Font(target.getFont().getName(), 1, target.getFont().getSize()));
                return;
            }
            case SOURCE: {
                if (expanded) {
                    DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/blue-opened.png");
                } else {
                    DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/blue-closed.png");
                }
                return;
            }
            case TEST_SOURCE: {
                if (expanded) {
                    DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/green-opened.png");
                } else {
                    DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/green-closed.png");
                }
                return;
            }
        }
        if (expanded) {
            DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/pile-opened.png");
        } else {
            DefaultFileTreeCellRenderer.applyIcon(target, "/de/renew/navigator/images/directories/pile-closed.png");
        }
    }
}

