/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.storables.impl.drawings;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.ioontology.importing.ImportFormatHolder;
import de.renew.ioontology.importing.ImportFormatListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class DrawingImportFormatHolder
implements ImportFormatHolder<Drawing> {
    private static final Logger LOGGER = Logger.getLogger(DrawingImportFormatHolder.class);
    private static DrawingImportFormatHolder _instance;
    private final List<ImportFormat<Drawing>> _importFormats = new LinkedList<ImportFormat<Drawing>>();
    private final List<ImportFormatListener<Drawing>> _importFormatListeners = new ArrayList<ImportFormatListener<Drawing>>();

    private DrawingImportFormatHolder() {
    }

    public static DrawingImportFormatHolder getInstance() {
        if (_instance == null) {
            _instance = new DrawingImportFormatHolder();
        }
        return _instance;
    }

    @Override
    public void addImportFormat(ImportFormat<Drawing> importFormat) {
        LOGGER.debug((Object)(String.valueOf(this.getClass()) + ": adding import format " + String.valueOf(importFormat)));
        this._importFormats.add(importFormat);
        for (ImportFormatListener<Drawing> listener : this._importFormatListeners) {
            listener.importFormatAdded(importFormat);
        }
    }

    @Override
    public void addImportFormatListener(ImportFormatListener<Drawing> listener) {
        this._importFormatListeners.add(listener);
    }

    @Override
    public List<ImportFormat<Drawing>> getImportFormats() {
        return this._importFormats;
    }

    @Override
    public void removeImportFormat(ImportFormat<Drawing> format) {
        this._importFormats.remove(format);
        for (ImportFormatListener<Drawing> listener : this._importFormatListeners) {
            listener.importFormatRemoved(format);
        }
    }

    @Override
    public void removeImportFormatListener(ImportFormatListener<Drawing> listener) {
        this._importFormatListeners.remove(listener);
    }
}

