/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.storables.impl.drawings;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.exporting.ExportFormatHolder;
import de.renew.ioontology.exporting.ExportFormatListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DrawingExportFormatHolder
implements ExportFormatHolder<Drawing> {
    private static final Logger LOGGER = Logger.getLogger(DrawingExportFormatHolder.class);
    private static DrawingExportFormatHolder _instance;
    private final List<ExportFormat<Drawing>> _exportFormats = new ArrayList<ExportFormat<Drawing>>();
    private final List<ExportFormatListener<Drawing>> _exportFormatListeners = new ArrayList<ExportFormatListener<Drawing>>();

    private DrawingExportFormatHolder() {
    }

    public static DrawingExportFormatHolder getInstance() {
        if (_instance == null) {
            _instance = new DrawingExportFormatHolder();
        }
        return _instance;
    }

    @Override
    public void addExportFormat(ExportFormat<Drawing> exportFormat) {
        LOGGER.debug((Object)(String.valueOf(this.getClass()) + ": adding export format " + String.valueOf(exportFormat)));
        this._exportFormats.add(exportFormat);
        for (ExportFormatListener<Drawing> listener : this._exportFormatListeners) {
            listener.exportFormatAdded(exportFormat);
        }
    }

    @Override
    public void addExportFormatListener(ExportFormatListener<Drawing> listener) {
        this._exportFormatListeners.add(listener);
    }

    @Override
    public List<ExportFormat<Drawing>> getExportFormats() {
        return this._exportFormats;
    }

    @Override
    public void removeExportFormat(ExportFormat<Drawing> exportFormat) {
        LOGGER.debug((Object)(String.valueOf(this.getClass()) + ": removing export format " + String.valueOf(exportFormat)));
        this._exportFormats.remove(exportFormat);
        for (ExportFormatListener<Drawing> listener : this._exportFormatListeners) {
            listener.exportFormatRemoved(exportFormat);
        }
    }

    @Override
    public void removeExportFormatListener(ExportFormatListener<Drawing> listener) {
        this._exportFormatListeners.remove(listener);
    }
}

